
#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "Watchdog.h"
#include "Ser25lcxxx.h"


extern string HARDWARE;
extern string SOFTWARE;
extern string AUTHOR;

extern Serial pc;//Debug Port via USB
extern Serial usart6;
extern SPI spi;//SPI
extern Ser25LCxxx eeprom;
extern Watchdog wd;

extern Timer tPop;
extern Timer tPush;
extern Timer tRst;
extern Timer tSpeed;

extern float minScale;
extern float maxScale;//Max Scale variable to stop max RPM, max ml/min and max %

extern char *readbuf;
extern bool maxFlag;
extern bool arrowFlag;

extern bool rmtFlag;
extern bool maxBtnPress;
extern uint8_t storedTask;//Remember the previous state machine state
extern volatile float ml;

///////////////////////////////////////////////////////////////////////////////
// STRUCTURES
///////////////////////////////////////////////////////////////////////////////
struct settingsNVM{
    uint8_t flowUnits;//0
    uint8_t runMode;//1
    uint8_t autoRestart;//2
    uint8_t pumpHeadStatus;//3
    uint8_t alarm;//4
    uint8_t headSide;//5   
    uint8_t pumpOnOff;//6 
    uint8_t spare;//7 

    float speedLimit;//8
    float flowUnitVal;//12             
    float mA_low;//16
    float mA_high;//20;  
    float flow_low;//24
    float flow_high;//28
    float adc_min_v;//32
    float adc_max_v;//36
    float dac_v_low;//40
    float dac_v_high;//44    

    uint8_t rmtStopPump;//48
    uint8_t outPut1;//Stores the setting, analogue, manual, run status, general alarm, leak detect, fluid level, contact mode on page 36    
    uint8_t outPut1Logic;//Output logic state can be HI or LO depend on tick box setting on page 36  
    uint8_t outPut2;//Stores the setting, analogue, manual, run status, general alarm, leak detect, fluid level, contact mode on page 36    
    uint8_t outPut2Logic;//Output logic state can be HI or LO depend on tick box setting on page 36       
    uint8_t _4_20mAoutPut;    

};

///////////////////////////////////////////////////////////////////////////////
// STRUCTURE DEFINITIONS
///////////////////////////////////////////////////////////////////////////////
extern struct settingsNVM nvm;

void sysInit(void);

#endif 
