#include <cstdlib>
#include <string> 
#include "main.h"
#include "Functions.h"
#include "Definitions.h"
#include "Boolean.h"
#include "NextionLCD.h"
#include "mbed.h"
#include "Languages.h"
#include "NVM.h"
#include "Controls.h"
#include "FastPWM.h"
#include <cstring>

///////////////////////////////////////////////////////////////////////////////
// MBED
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// VARIABLES
///////////////////////////////////////////////////////////////////////////////
bool scrnUpdate = true;//Update the Nexion screen

volatile bool keyScanFlag;

uint8_t nexDataLSB;
uint8_t nexDataMSB;
volatile uint8_t page = 0;
volatile uint8_t id= 0;
volatile bool pushPop = 0;

///////////////////////////////////////////////////////////////////////////////
// CONSTANTS
///////////////////////////////////////////////////////////////////////////////
bool push = 1;
bool pop = 0;

///////////////////////////////////////////////////////////////////////////////
// DEBUG
///////////////////////////////////////////////////////////////////////////////
volatile char dbgNexMsg[20];
volatile int dbgMRxIdx;
volatile bool debugFlag;
volatile bool tx_true;

NextionLCD::NextionLCD(PinName Tx, PinName Rx) : lcd(Tx, Rx){
    lcd.baud(9600);    
    mTouch=false;
    mRxIdx=0;
    lcd.printf("rest%c%c%c", 0xff, 0xff, 0xff);    
    lcd.printf("rest%c%c%c", 0xff, 0xff, 0xff);

    #ifdef DEBUG_LCD
        pc.printf("\r\n\r\nNextionLCD Rst\r\n");
    #endif   

    wait(1.0);
    lcd.attach(callback(this,&NextionLCD::RxInterrupt),Serial::RxIrq);
}

void NextionLCD::nexRst(void){
    lcd.printf("rest%c%c%c", 0xff, 0xff, 0xff);   
    lcd.printf("rest%c%c%c", 0xff, 0xff, 0xff);

    #ifdef DEBUG_LCD
        pc.printf("\r\n\r\nnexRst\r\n");
    #endif      
}

void NextionLCD::nexSetFont(string id, uint8_t val){
    static string newId = 0;
    static uint8_t newVal = 0;
    
    if((id != newId)||(val != newVal)){    
        lcd.printf("%s.font=%d%c%c%c",id.c_str(),val, 0xff, 0xff, 0xff); 
        newId = id;
        newVal = val;

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexSetFont %s %d\r\n",id.c_str(),val);
        #endif            
    }
}

void NextionLCD::nexSetBckLite(uint8_t val){//ok
/*
dim : use dim to instanteniously change backlight intensity, this is not saved in NVM and forgotten once power cycled
dims: use dims to instanteniously change backlight intensity, this is saved in NVM and remembered after power cycle.
*/
    static uint8_t newVal = 0;

    if(val != newVal){
        lcd.printf("dims=%d%c%c%c",val, 0xff, 0xff, 0xff);
        newVal = val;

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexSetBcklite = %d\r\n",val);
        #endif            
    }
}

void NextionLCD::nexSetBaud(uint32_t baud){//ok
    static uint32_t newBaud = 0;

    if(baud != newBaud){
        lcd.printf("baud=%d%c%c%c",baud, 0xff, 0xff, 0xff);//Set Nextion display to high baud    
        wait(0.5);    
        lcd.baud(baud);//Set Mbed target to high baud    
        wait(0.5);    
        newBaud = baud;

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexSetBaud = %u\r\n",baud);
        #endif            
    }
}

void NextionLCD::nexChgPage(uint8_t nexPage){//ok
    lcd.printf("page %d%c%c%c",nexPage,0xff, 0xff, 0xff);    

    #ifdef DEBUG_LCD
        pc.printf("\r\n\r\nnexChgPage = %d\r\n",nexPage);
    #endif          
}

void NextionLCD::nexSetDSBtn(string id, uint8_t on_off){    
    
    if(on_off == ON)
        lcd.printf("%s.val=1%c%c%c",id.c_str(),0xff, 0xff, 0xff);     
    else
        if(on_off == OFF)
            lcd.printf("%s.val=0%c%c%c",id.c_str(),0xff, 0xff, 0xff);     
                      
    #ifdef DEBUG_LCD
        pc.printf("\r\n\r\nnexSetDSBtn %s %d\r\n",id.c_str(),on_off);
    #endif                    
}

void NextionLCD::nexRotArrow(bool on_off){//ok
    static bool newOnOff = 0;
 
    if(on_off != newOnOff){

        if(on_off == ON){
            lcd.printf("arrow.picc=19%c%c%c", 0xff, 0xff, 0xff);    
            lcd.printf("arrowTimer.en=1%c%c%c", 0xff, 0xff, 0xff); 
        }
        else
            if(on_off == OFF){
                lcd.printf("arrowTimer.en=0%c%c%c", 0xff, 0xff, 0xff); 
                lcd.printf("arrow.picc=18%c%c%c", 0xff, 0xff, 0xff);             
            }

        newOnOff = on_off;


        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexRotArrow = %d\r\n", on_off);
        #endif             
    }          
}

void NextionLCD::nexDispSymbol(string id, bool on_off){   
    static string newId = 0;    
    static bool newOnOff = 0;
    
    if((id != newId)||(on_off!= newOnOff)){        

        if(on_off == ON)
            nexSetCrop(id, 1);//display symbol      
        else
            if(on_off == OFF)        
                nexSetCrop(id, 16);//white page                  

        newId = id;    
        newOnOff = on_off;       

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexDispSymbol %s %d\r\n", id.c_str(),on_off );
        #endif              
    }
}

void NextionLCD::nexSetCrop(string id, uint16_t picc){//ok
/*
   q0 = arrow crop image
   picc = 1//Turn rotation arrow off
   picc = 2// pos1 displayed
   picc = 3// pos2 displayed
   picc = 4// pos3 displayed
   picc = 5// pos4 displayed    

*/ 
    static string newId = 0;
    static uint16_t newPicc = 0;

    if((id != newId)||(picc!= newPicc)){
        lcd.printf("%s.picc=%d%c%c%c",id.c_str(),picc,0xff, 0xff, 0xff);     
        newId = id;     
        newPicc = picc;

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexSetCrop %s %d\r\n", id.c_str(),picc);
        #endif             
    }
}

void NextionLCD::nexSetTimer(string id,uint16_t tim, uint16_t on_off){//ok
    lcd.printf("%s.tim=%d%c%c%c",id.c_str(),tim,0xff, 0xff, 0xff);      
    lcd.printf("%s.en=%d%c%c%c",id.c_str(),on_off,0xff, 0xff, 0xff);    

    #ifdef DEBUG_LCD
        pc.printf("\r\n\r\nnexSetTimer %s %d %d \r\n", id.c_str(),tim,on_off);
    #endif                    
}

void NextionLCD::nexSetSlider(string id, uint16_t sliderVal){//ok
    static string newId = 0;
    static uint16_t newSliderVal = 0;

    if((id != newId)||(sliderVal!= newSliderVal)){
        lcd.printf("%s.val=%d%c%c%c",id.c_str(),sliderVal,0xff, 0xff, 0xff);         
        newId = id;
        newSliderVal = sliderVal;

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexSetSlider %s %d\r\n", id.c_str(),sliderVal);
        #endif             
    }
}

void NextionLCD::nexSetPrgBar(string id, uint16_t progBarVal){//ok
    static string newId = 0;
    static uint16_t newProgBarVal = 0;

    if((id != newId)||(progBarVal!= newProgBarVal)){
        lcd.printf("%s.val=%d%c%c%c",id.c_str(),progBarVal,0xff, 0xff, 0xff);         
        newId = id;
        newProgBarVal = progBarVal;

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexSetPrgBar %s %d\r\n", id.c_str(),progBarVal);
        #endif          
    }      
}

void NextionLCD::nexSendTxt(string id,string txt){//ok
    static string newId = 0;
    static string newTxt = 0;
    
    if((id != newId)||(txt != newTxt)){
        lcd.printf("%s.txt=\"%s\"%c%c%c",id.c_str(),txt.c_str(),0xff, 0xff, 0xff);           
        newId = id;
        newTxt = txt;

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexSendTxt %s %s\r\n",id.c_str(),txt.c_str());
        #endif           
    }        
}

void NextionLCD::nexSendFloat(string id, float val ,uint8_t precision){
/*
    In C, the printf() statement allows the precision lengths to be supplied in the parameter list.

    printf("%*.*f", 7, 3, floatValue);

    where the asterisks are replaced with first and second values, respectively.    
*/
    static string newId = 0;
    static float newVal = 0;
    
    if((id != newId)||(val != newVal)){        
        lcd.printf("%s.txt=\"%.*f\"%c%c%c",id.c_str(), precision, val, 0xff, 0xff, 0xff);                
        newId = id;
        newVal = val;

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexSendFloat string=%s, pre=%d, val=%f\r\n",id.c_str(), precision, val);        
        #endif          
    }
}

void NextionLCD::nexSetFontCol(string id, uint16_t color){    
    static string newId = 0;    
    static uint16_t newColor = 0;    

    if((id != newId)||(color!= newColor)){
        lcd.printf("%s.pco=%d%c%c%c",id.c_str(),color,0xff, 0xff, 0xff);   
        newId = id;    
        newColor = color;

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexSetFontCol %s %d\r\n", id.c_str(),color);
        #endif          
    }
}

void NextionLCD::nexSendVal(string id,uint16_t val){
    static string newId = 0;
    static uint16_t newVal = 0;
    
    if((id != newId)||(val!= newVal)){    
        lcd.printf("%s.txt=\"%d\"%c%c%c",id.c_str(), val, 0xff, 0xff, 0xff);         
        newId = id;
        newVal = val;

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexSendVal %s %d\r\n", id.c_str(),val);
        #endif          
    }
}

void NextionLCD::nexSendGetVal(string id){
    static string newId = 0;

    if(id != newId){    
        lcd.printf("get %s.val%c%c%c",id.c_str(),0xff, 0xff, 0xff);   
        newId = id;

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexSendGetVal %s\r\n",id.c_str());
        #endif          
    }             
}

void NextionLCD::ClrScr(uint16_t color){//ok 
    lcd.printf("cls %d%c%c%c", color, 0xff, 0xff, 0xff);        

    #ifdef DEBUG_LCD
        pc.printf("\r\n\r\nClrScr %d\r\n",color);
    #endif      
}

void NextionLCD::nexLoadSD(void){
    nexPwrCont = ON;//Nextion power is on    
    wait(0.50);            
    nexSetBckLite(5);//program backlight to be off at power up
    wait(5.0);      
    nexPwrCont = OFF;
    wait(5.0);    
    nexPwrCont = ON;//Nextion power is on   
    wait(0.25);        

    #ifdef DEBUG_LCD
        pc.printf("\r\n\r\nnexLoadSD\r\n");
    #endif      
}

void NextionLCD::nexDrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color) {
    static uint16_t newX1,newY1,newX2,newY2,newColor = 0;

    if((x1 != newX1)||(y1 != newY1)||(x2 != newX2)||(y2 != newY2)||(color != newColor)){
        lcd.printf("line %d,%d,%d,%d,%d%c%c%c", x1, y1, x2, y2, color, 0xff, 0xff, 0xff);
        newX1 = x1;
        newY1 = y1;
        newX2 = x2;
        newY2 = y2;
        newColor = color;       

        #ifdef DEBUG_LCD
            pc.printf("\r\n\r\nnexDrawLine x1=%d y1=%d x2=%d y2=%d col=%d\r\n",x1, y1, x2, y2, color);
        #endif                                   
    }
}

void NextionLCD::RxInterrupt(void){
/*
    Decode Nextion messages
*/    
    char c;
    
    if(lcd.readable()){

        debugFlag = true;//Debug all 

        c = lcd.getc(); 
        mRxMsg[mRxIdx] = c;  
        dbgNexMsg[mRxIdx] = c;//make a copy of the message in dbgNexMsg[]     
        dbgMRxIdx = mRxIdx++;//Save a copy of the index counter in dbgMRxIdx


        /* 
            These are touch screen evernt and by there nature slow so 
            it should no be necessary to have to process these received touch event that quickly
            so no need to just set a flag in the RX ISR and let a thread do the processing it can 
            ALL be done with the RX ISR
        */


        if((mRxIdx >= 3) && (mRxMsg[mRxIdx-1] == 0xff) && (mRxMsg[mRxIdx-2] == 0xff) && (mRxMsg[mRxIdx-3] == 0xff)){//valid rx message           
        
            mRxIdx=0;
            //////////////////////////////debugFlag = true;

            //led1=1; 
        
            if(mRxMsg[0] == TOUCH_EVENT){//Nextion RX Touch Event

                page = mRxMsg[PAGE];//get the page
                id = mRxMsg[ID];//get the component ID
                pushPop = mRxMsg[PUSHPOP];//get the push/pop state

                keyScanFlag = true;//set key scn flag for main routine

            }
         
            if(mRxMsg[0] == 0x71){//Nextion RX Numeric Data
                //led1=1;                            
                scrnUpdate = true;
                nexDataLSB = mRxMsg[1];
                nexDataMSB = mRxMsg[2];
            }            
        }
    }
}
