#ifndef CONTROLS_H 
#define CONTROLS_H 

#include "mbed.h"
#include "FastPWM.h"

//DVR8603 BLDC Motor Controller
extern DigitalOut motEnable;
extern DigitalOut motDir;
extern DigitalOut nBrake;
extern DigitalIn nFault;

//ADC/DAC
extern AnalogIn ain;
extern AnalogOut aout;

//Nucleo Debug LEDs
extern DigitalOut led1;
extern DigitalOut led2;
extern DigitalOut led3;

//Button Membrane  
extern DigitalOut startLED;
extern DigitalOut stopLED;
extern DigitalIn startButton;
extern DigitalIn stopButton;

//4-20mA Control Inputs
extern DigitalIn rmtRunStop;// Run / Stop Input
extern DigitalIn rmtExtCont;//External Contact Input
extern DigitalIn rmtFldRec;//Remote Fluid Recovery Inputs

//Leak detection
extern DigitalIn leakIn;

//4-20mA Control Outputs
extern DigitalOut alarmOut1;
extern DigitalOut alarmOut2;

//Netxion Power Control
extern DigitalOut nexPwrCont;

//extern PwmOut pwm;
extern FastPWM pwm;

extern float motorSpeed;
extern float flowPercent;
extern float lastMaxScale;



bool startBtn(bool byPassPress);
bool stopBtn(bool byPassPress);

void confPWM(void);
void confMotor(void);
void confBtn(void);
uint8_t anaIn(void);
uint8_t manual(void);
uint8_t contactMode(void);
uint8_t flowCalMode(void);
uint8_t fluidRecMode(void);
void reset(void);
void anaOut_mA(float mA);
void anaOutScale(float mA_FullScale, float mA_MatchScale);
float anaIn_mA(void);
void ledClr(void);
uint8_t motor(float rpmSetPoint, bool dir, bool brake, bool enable, float rampTime);
void ConfInputSw(void);
uint8_t startUpMode(uint8_t runMode);
bool runStopSignal(bool runStopSig, struct settingsNVM *nvm);   
void outPuts(bool leakDetection, struct settingsNVM *nvm);
bool leakDetect(bool leakInput);

#endif
