#include <cstdlib>
#include <string> 
#include "main.h"
#include "Functions.h"
#include "Definitions.h"
#include "Boolean.h"
#include "NextionLCD.h"
#include "mbed_debug.h"
#include "mbed.h"
#include "Languages.h"
#include "Ser25lcxxx.h"
#include "NVM.h"
#include "Watchdog.h"
#include "Controls.h"
#include "Threads.h"
#include "FastPWM.h"

///////////////////////////////////////////////////////////////////////////////
// MBED OBJECTS
///////////////////////////////////////////////////////////////////////////////
extern NextionLCD lcd;//Tx, Rx, Nextion Port

///////////////////////////////////////////////////////////////////////////////
// VARIABLES
///////////////////////////////////////////////////////////////////////////////
bool calComplete = false;
uint8_t precision = 0;
uint8_t adjustItem = ADJ_FLOW_UNITS;
uint8_t menuStringID = FLOW_U_STRING_LIST;//store the last displayed list

///////////////////////////////////////////////////////////////////////////////
// STRINGS
///////////////////////////////////////////////////////////////////////////////
extern string HARDWARE;
extern string SOFTWARE;
extern string BUILD;
extern string DATE; 
extern string AUTHOR;   

///////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
///////////////////////////////////////////////////////////////////////////////
uint8_t nexPage(uint8_t presentTask, uint8_t savedTask){
    
    const uint8_t x=0,y=1,z=2;
    static uint8_t i[3]={x,y,z};
    uint8_t task = presentTask;//return the present task unless task in re-assigned by pages

    switch(page){
        case PAGE_0:                    break;

        case PAGE_1_HOME:                     
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 1 HOME
                                        ///////////////////////////////////////////////////////////////////////////////           
                                        if(touchBtn(PAGE_1_HOME, P1_INC, PUSH)){
                                            tPush.start();
                                            tSpeed.start();                                    
                                            tPop.stop();
                                            tPop.reset();
                                            incFlag = true; 
                                            scrnUpdate = true;
                                            led1=1;
                                            led2=0;
                                        }
                                        else
                                        if(touchBtn(PAGE_1_HOME, P1_DEC, PUSH)){
                                            tPush.start(); 
                                            tSpeed.start();                                
                                            tPop.stop();
                                            tPop.reset();        
                                            decFlag = true; 
                                            scrnUpdate = true;    
                                            led3=1;
                                            led1=0;     
                                        }
                                        else
                                        if(touchBtn(PAGE_1_HOME, P1_INC, POP)){
                                            tPush.stop(); 
                                            tPush.reset();
                                            tPop.start();
                                            incFlag = false;     
                                            led1=0;
                                            led2=1;  
                                        }

                                        if(touchBtn(PAGE_1_HOME, P1_DEC, POP)){
                                            tPush.stop(); 
                                            tPush.reset();
                                            tPop.start();
                                            decFlag = false;     
                                            led3=0;
                                            led1=1;  
                                        }
                                        else
                                        if(touchBtn(PAGE_1_HOME, P1_MAX, PUSH)){    
                                            maxBtnPress = true;             
                                            task = MAX;                                       
                                        }
                                        else                                                            
                                        if(touchBtn(PAGE_1_HOME, P1_MAX, POP)){    
                                            maxBtnPress = false;
                                        }
                                        else
                                        if(touchBtn(PAGE_1_HOME, P1_SET, PUSH)){//load the auto restart button with its NVM setting

                                            if(nvm.autoRestart == AUTO_RESTART_ON)
                                                lcd.nexSetDSBtn("bt0",ON);
                                            else    
                                                if(nvm.autoRestart == AUTO_RESTART_OFF)
                                                lcd.nexSetDSBtn("bt0",OFF);   
                                        }            
                                        break;

        case PAGE_2_INFO:
                                        break;
        case PAGE_3_MAIN:
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 3 MAIN MENU
                                        ///////////////////////////////////////////////////////////////////////////////            
/*                                        
                                        if(touchBtn(PAGE_3_MAIN, P3_FLUID_LEV_MON, PUSH)){                            

                                        }
                                        else
                                        if(touchBtn(PAGE_3_MAIN, P3_SECURITY, PUSH)){                            
                                            
                                        }
                                        else
                                        if(touchBtn(PAGE_3_MAIN, P3_CONT_SETTINGS, PUSH)){   
                        
                                            
                                        }  
                                        else
*/                                        
                                        if(touchBtn(PAGE_3_MAIN, P3_INFO, PUSH)){    

                                            //lcd.nexChgPage(BLANK_PAGE);


                                            
                                            lcd.nexChgPage(PAGE_27_ABOUT);
                                            lcd.nexSendTxt("hardware",HARDWARE);                                                 
                                            lcd.nexSendTxt("software",SOFTWARE);                                                                                                
                                            lcd.nexSendTxt("date",__DATE__);  
                                            lcd.nexSendTxt("time",__TIME__);                                               
                                            lcd.nexSendTxt("author",AUTHOR);                                                                                                                                                                                                  
                                            
                                        }  
                                        else
                                        if(touchBtn(PAGE_3_MAIN, P3_BACK, PUSH))
                                        task = retLastStoredTask(savedTask);                                             
                                    
                                        break;    
                                        

        case PAGE_7_FLUID_LEV_SET:
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 7 FLUID LEVEL SETTINGS
                                        ///////////////////////////////////////////////////////////////////////////////    
/*                                        
                                        if(touchBtn(PAGE_7_FLUID_LEV_SET, P7_HOME, PUSH))
                                            task = retLastStoredTask(savedTask); 
*/                                                               
                                        break;      

        case PAGE_8_FLOWU_ADJ:

                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 8 FLOW UNIT ADJUSTMENT
                                        ///////////////////////////////////////////////////////////////////////////////                                                                                                                                                        
                                        if(touchBtn(PAGE_8_FLOWU_ADJ, P8_DEC, PUSH))   
                                            dispList(i, DEC, menuStringID, menuStringArray, P8_MENU_ITEMS);                                                                                
                                        else
                                        if(touchBtn(PAGE_8_FLOWU_ADJ, P8_INC, PUSH))   
                                            dispList(i, INC, menuStringID, menuStringArray, P8_MENU_ITEMS);  
                                        else
                                        if(touchBtn(PAGE_8_FLOWU_ADJ, P8_OK, PUSH)){     
                                            lcd.nexSetFontCol("data", GREEN);                          
                                            nvm.flowUnits = uFlowUnitID[i[1]]; 
                                            writeNVMByte(NVM_FLOW_UNITS,nvm.flowUnits);                                    
                                            decodeByteNVM(nvm.flowUnits, &precision);
                                            nvm.flowUnitVal = ((flowPercent/100)*maxScale);
                                            writeNVMfloat(NVM_FLOWU_VAL,nvm.flowUnitVal);                                                                                                                                                                                                                                                                                      
                                        }
                                        else
                                        if(touchBtn(PAGE_8_FLOWU_ADJ, P8_HOME, PUSH))   
                                            task = retLastStoredTask(savedTask);                                         
                                        else
                                        if(touchBtn(PAGE_8_FLOWU_ADJ, P8_BACK, PUSH))                                           
                                            lcd.nexChgPage(PAGE_9_SETTINGS);                                                                      
                                        break;         

        case PAGE_9_SETTINGS:
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 9 GENERAL SETTINGS
                                        ///////////////////////////////////////////////////////////////////////////////    
                                        if(touchBtn(PAGE_9_SETTINGS, P9_AUTO_RESTART, PUSH)){                                                  
                                            if(nvm.autoRestart ==  AUTO_RESTART_ON){//read the present auto restart state and toggle to alternative state                                    
                                                lcd.nexSetDSBtn("bt0",OFF);

                                                nvm.autoRestart = AUTO_RESTART_OFF;
                                                writeNVMByte(NVM_AUTO_RESTART, nvm.autoRestart);                    
                                            }
                                            else    
                                                if(nvm.autoRestart ==  AUTO_RESTART_OFF){
                                                    lcd.nexSetDSBtn("bt0",ON);

                                                    nvm.autoRestart = AUTO_RESTART_ON;
                                                    writeNVMByte(NVM_AUTO_RESTART, nvm.autoRestart);                                                                                 
                                                }    
                                            //DO NOT RETURN TO A TASK  
                                        }
                                        else
                                        if(touchBtn(PAGE_9_SETTINGS, P9_FLOW_UNITS, PUSH)){                                                  
                                            lcd.nexChgPage(PAGE_8_FLOWU_ADJ);
                                            //lcd.nexSendTxt("title","Flow Units");    
                                            //lcd.nexSendTxt("btnOK","OK");                    

                                            menuStringID = FLOW_U_STRING_LIST;

                                            i[y] = decodeByteNVM(nvm.flowUnits, &precision);

                                            if(i[y] == 0){i[x] = 9; i[z] = 1;}                                            
                                            else
                                            if(i[y] == 9){i[x] = 8; i[z] = 0;}
                                            else{i[x] = (i[1]-1); i[z] = (i[1]+1);}

                                            lcd.nexSendTxt("top",menuStringArray[0][i[x]]); 
                                            lcd.nexSendTxt("data",menuStringArray[0][i[y]]);   
                                            lcd.nexSendTxt("bot",menuStringArray[0][i[z]]); 
                                        }
/*                                        
                                        else
                                        if(touchBtn(PAGE_9_SETTINGS, P9_ASS_NUM, PUSH)){                                                  

                                        }
                                        else
                                        if(touchBtn(PAGE_9_SETTINGS, P9_PUMP_LAB, PUSH)){                                                  

                                        }
                                        else
                                        if(touchBtn(PAGE_9_SETTINGS, P9_RESTORE, PUSH)){                                                  

                                        }
                                        else
                                        if(touchBtn(PAGE_9_SETTINGS, P9_LANG, PUSH)){                                                  

                                        }           
                                        else
*/                                        
                                        if(touchBtn(PAGE_9_SETTINGS, P9_BACK, PUSH))
                                            task = retLastStoredTask(savedTask); 
                                        
                                        break;            

        case PAGE_11_RESET:           
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 11 RESET RUN HOURS / RESET VOLUME COUNTER
                                        ///////////////////////////////////////////////////////////////////////////////
                                        if(touchBtn(PAGE_11_RESET, P11_RESET, PUSH)){    

                                            lcd.nexChgPage(PAGE_11_RESET);
/*                                    
                                            if(runHours)                          
                                                lcd.nexSendFloat("info1",0.0);                                           
                                            else
                                            if(volCntr)                                    
                                                lcd.nexSendFloat("info1",0.0);                 
*/                                        
                                        }  
                                        break;

        case PAGE_12_MODE:
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 12 CHANGE MODE
                                        ///////////////////////////////////////////////////////////////////////////////     
                                        if(touchBtn(PAGE_12_MODE, P12_MANUAL, PUSH)){                                            
                                            nvm.runMode = MANUAL;//set manual mode
                                            writeNVMByte(NVM_RUN_MODE, nvm.runMode);//update EEPROM with manual mode             
                                            //lcd.nexChgPage(PAGE_1_HOME);                                                                                                                                                                                                                                                                                         
                                            task = STOP_SCRN;                                     
                                        }
                                        else
                                        if(touchBtn(PAGE_12_MODE, P12_ANALOGUE, PUSH)){     
                                            nvm.runMode = ANALOGUE;//set analogue mode
                                            writeNVMByte(NVM_RUN_MODE, nvm.runMode);//update EEPROM with analogue mode     
                                            //lcd.nexChgPage(PAGE_1_HOME);                                                                                                                         
                                            task = ANALOGUE_SET;                                    
                                        }
                                        else
                                        if(touchBtn(PAGE_12_MODE, P12_ANA_CAL, PUSH)){  

                                            calComplete = false;//for new calibration entry make sure this flag is cleared

                                            lcd.nexChgPage(PAGE_18_ANA_CAL_MODE);    
                                            //lcd.nexSendTxt("btnLeft","Analogue");    
                                            //lcd.nexSendTxt("btnRight","Manual");                                    
                                            //lcd.nexSendTxt("title","4-20mA Calibration");    
                                            //lcd.nexSendTxt("info1","Select Analogue Signal");    
                                            //lcd.nexSendTxt("info2","or");  
                                            //lcd.nexSendTxt("info3","Manual Input");          
                                            //lcd.nexSendTxt("info4","Calibration"); 
                                        }                                                
                                        else
                                        if(touchBtn(PAGE_12_MODE, P12_CONTACT, PUSH)){  
                                            //nvm.runMode = CONTACT; 
                                            //writeNVMByte(NVM_RUN_MODE,nvm.runMode);                             
                                            //task = runModeNVM(nvm.runMode);//reload page 1 titles   
                                        }     
                                        else
                                        if(touchBtn(PAGE_12_MODE, P12_FLUID_REC, PUSH)){     
                                            //nvm.runMode = FLUIDREC; 
                                            //writeNVMByte(NVM_RUN_MODE,nvm.runMode);
                                            //task = runModeNVM(nvm.runMode);//reload page 1 titles  
                                        }                                         
                                        else
                                        if(touchBtn(PAGE_12_MODE, P12_FLOW_CAL, PUSH)){   

                                        }
                                        else
                                        if(touchBtn(PAGE_12_MODE, P12_BACK, PUSH)){   
                                            task = retLastStoredTask(savedTask);  
                                        }                                           
                                        break;

        case PAGE_14_ANA_CAL:
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 14 ANALOGUE CALIBRATION CONTROLS
                                        ///////////////////////////////////////////////////////////////////////////////                                                       
                                        if(touchBtn(PAGE_14_ANA_CAL, P14_INC, PUSH)){
                                            tPush.start(); 
                                            tPop.stop();
                                            tPop.reset();
                                            incFlag = true; 
                                            scrnUpdate = true;
                                            led1=1;
                                            led2=0;
                                        }
                                        else
                                        if(touchBtn(PAGE_14_ANA_CAL, P14_DEC, PUSH)){ 
                                            tPush.start(); 
                                            tPop.stop();
                                            tPop.reset();        
                                            decFlag = true;         
                                            scrnUpdate = true;    
                                            led3=1;
                                            led1=0;        
                                        }
                                        else
                                        if(touchBtn(PAGE_14_ANA_CAL, P14_INC, POP)){
                                            tPush.stop(); 
                                            tPush.reset();
                                            tPop.start();
                                            incFlag = false;     
                                            led1=0;
                                            led2=1;
                                        }  
                                        else 
                                        if(touchBtn(PAGE_14_ANA_CAL, P14_DEC, POP)){
                                            tPush.stop(); 
                                            tPush.reset();
                                            tPop.start();
                                            decFlag = false;            
                                            led3=0;
                                            led1=1;        
                                        }  
                                        else
                                        if(touchBtn(PAGE_14_ANA_CAL, P14_OK, PUSH)){ 
                                            okFlag = true; scrnUpdate = true;    
                                        }
                                        else
                                        if(touchBtn(PAGE_14_ANA_CAL, P14_BACK, PUSH)){ 
                                            stopLED = OFF; 
                                            task = STOP_SCRN;
                                            
                                        }                                                     
                                        break;   

        case PAGE_18_ANA_CAL_MODE:
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 18 4-20mA CALIBRATION MODE
                                        ///////////////////////////////////////////////////////////////////////////////     
                                        if(touchBtn(PAGE_18_ANA_CAL_MODE, P18_MAN, PUSH)){   
                                            if(calComplete){
                                                nvm.runMode = MANUAL;
                                                writeNVMByte(NVM_RUN_MODE, nvm.runMode);//update EEPROM with manual mode                                                               
                                                task = STOP_SCRN;                                                                           
                                            }   
                                            else 
                                            {                                   
                                                reset();                                               
                                                manFlag = true;//manual cal mode                                            
                                                lcd.nexChgPage(PAGE_14_ANA_CAL);                                             
                                                calState = CAL1_SCRN;   
                                                scrnUpdate = true;                         
                                                task = ANA_CAL;                            
                                            }                                                
                                        }
                                        else                                                                                    
                                        if(touchBtn(PAGE_18_ANA_CAL_MODE, P18_INPUT, PUSH)){   
                                            if(calComplete){
                                                nvm.runMode = ANALOGUE;
                                                writeNVMByte(NVM_RUN_MODE,nvm.runMode);                                                                                 
                                                task = STOP_SCRN;
                                            }   
                                            else{                                                                    
                                                reset();                              
                                                manFlag = false;//signal cal mode                    
                                                lcd.nexChgPage(PAGE_14_ANA_CAL);     
                                                calState = CAL1_SCRN;  
                                                scrnUpdate = true;                
                                                task = ANA_CAL;
                                            }  
                                        }                                                 
                                        break;         

        case PAGE_27_ABOUT:
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 27 INFOMATION
                                        ///////////////////////////////////////////////////////////////////////////////                                                   
                                        if(touchBtn(PAGE_27_ABOUT, P27_BACK, PUSH))                                                                   
                                            task = retLastStoredTask(savedTask);                                                                                            
                                        break;

        case PAGE_33_MA_OUT:
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 33 mA OUTPUT
                                        //////////////////////////////////////////////////////////////////////////////        
                                        if(touchBtn(PAGE_33_MA_OUT, P33_FULL_SCALE, PUSH)){                                                  
                                            lcd.nexSetDSBtn("bt1", UNTICK);//display no tick
                                            lcd.nexSetDSBtn("bt0", TICK);//display output low tick
                                            nvm._4_20mAoutPut = _4_20MA_OUT_FULL_SCALE;
                                            writeNVMByte(NVM_4_20MA_OUT,nvm._4_20mAoutPut);                                                                                                                                                                
                                        }       
                                        else
                                        if(touchBtn(PAGE_33_MA_OUT, P33_MATCH, PUSH)){                                                                                     
                                            lcd.nexSetDSBtn("bt0", UNTICK);//display no tick 
                                            lcd.nexSetDSBtn("bt1", TICK);//display output high tick
                                            nvm._4_20mAoutPut = _4_20MA_OUT_MATCH_INPUT_SCALE;
                                            writeNVMByte(NVM_4_20MA_OUT,nvm._4_20mAoutPut);                                                                                                                                                                                                                               
                                        }    
                                        break;                                                                                                                     

        case PAGE_34_START_STOP:            
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 34 RUN/STOP INPUT
                                        //////////////////////////////////////////////////////////////////////////////                        
                                        if(touchBtn(PAGE_34_START_STOP, P34_LOW, PUSH)){                                                  
                                            lcd.nexSetDSBtn("bt0", UNTICK);                                            
                                            lcd.nexSetDSBtn("bt1", TICK);                     
                                            nvm.rmtStopPump = RMT_STOP_PUMP_LOW;
                                            writeNVMByte(NVM_RMT_STOP_PUMP,nvm.rmtStopPump);                                                                                                                                                                
                                        }       
                                        else
                                        if(touchBtn(PAGE_34_START_STOP, P34_HIGH, PUSH)){                                                                                     
                                            lcd.nexSetDSBtn("bt0", TICK);//display no tick 
                                            lcd.nexSetDSBtn("bt1", UNTICK);//display output high tick
                                            nvm.rmtStopPump = RMT_STOP_PUMP_HIGH; 
                                            writeNVMByte(NVM_RMT_STOP_PUMP,nvm.rmtStopPump);                                                                                                                                                                                                                               
                                        }       
                                        else                                                                                                                                                                                                              
                                        if(touchBtn(PAGE_34_START_STOP, P34_HOME, PUSH))  
                                            lcd.nexChgPage(PAGE_1_HOME);   
                                        else                                            
                                        if(touchBtn(PAGE_34_START_STOP, P34_BACK, PUSH))  
                                            lcd.nexChgPage(PAGE_3_MAIN);                                                                                                                                                  
                                        break;

        case PAGE_35_CONT_SET:
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 35 INPUT/OUTPUT CONTROL SETTINGS
                                        ///////////////////////////////////////////////////////////////////////////////       
                                        if(touchBtn(PAGE_35_CONT_SET, P35_INPUT, PUSH)){//input button pressed                                   
                                            lcd.nexChgPage(PAGE_34_START_STOP);
                                            lcd.nexSendTxt("title34","Run/Stop input");       

                                            if(nvm.rmtStopPump == RMT_STOP_PUMP_LOW){//Read the settings
                                                lcd.nexSetDSBtn("bt0", UNTICK);//display info                                                                                             
                                                lcd.nexSetDSBtn("bt1", TICK);//display info                                                                                                                     
                                            }
                                            else
                                            if(nvm.rmtStopPump == RMT_STOP_PUMP_HIGH){//Read the settings   
                                                lcd.nexSetDSBtn("bt0", TICK);//display info                                                
                                                lcd.nexSetDSBtn("bt1", UNTICK);//display info
                                            }                                                                               
                                        }
                                        else
                                        if(touchBtn(PAGE_35_CONT_SET, P35_OUTPUT1, PUSH)){//Output 1 button pressed   
                                            lcd.nexChgPage(PAGE_36_CONT_ADJ);       

                                            if(nvm.outPut1Logic == OUT1_LOGIC_HI){//Read the settings                                                
                                                lcd.nexSetDSBtn("bt1", TICK);//display info
                                                lcd.nexSetDSBtn("bt0", UNTICK);//display info                                                  
                                            }
                                            else
                                            if(nvm.outPut1Logic == OUT1_LOGIC_LO){//Read the settings
                                                lcd.nexSetDSBtn("bt1", UNTICK);//display info
                                                lcd.nexSetDSBtn("bt0", TICK);//display info
                                            }
                                                                                          
                                            lcd.nexSendTxt("title36","Output 1");    
                                            lcd.nexSendTxt("t0","LOW");      
                                            lcd.nexSendTxt("t1","HIGH");                                                                    
                                            menuStringID = OUTPUT1_LIST;  
                                            i[y] = ReadListIndexNVM(nvm.outPut1);                                                                                                           
                                            lcd.nexSendTxt("data",menuStringArray[menuStringID][i[y]]);                                                
                                        }                                          
                                        else
                                        if(touchBtn(PAGE_35_CONT_SET, P35_OUTPUT2, PUSH)){//Output 2 button pressed  
                                            lcd.nexChgPage(PAGE_36_CONT_ADJ);//display        

                                            if(nvm.outPut2Logic == OUT2_LOGIC_HI){                                                
                                                lcd.nexSetDSBtn("bt1", TICK);//display info 
                                                lcd.nexSetDSBtn("bt0", UNTICK);//display info
                                            }
                                            else
                                            if(nvm.outPut2Logic == OUT2_LOGIC_LO){
                                                lcd.nexSetDSBtn("bt1", UNTICK);//display info
                                                lcd.nexSetDSBtn("bt0", TICK);//display info
                                            }
                                                                                                                                                                                                                                                           
                                            lcd.nexSendTxt("title36","Output 2");//display   
                                            lcd.nexSendTxt("t0","LOW");      
                                            lcd.nexSendTxt("t1","HIGH");                                      
                                            menuStringID = OUTPUT2_LIST;//set the menu string ID for list for output 2   
                                            i[y] = ReadListIndexNVM(nvm.outPut2);//get the index of the present output 2 setting from nvm
                                            lcd.nexSendTxt("data",menuStringArray[menuStringID][i[y]]);//display the current nvm setting                                            
                                        }       
                                        else
                                        if(touchBtn(PAGE_35_CONT_SET, P35_MA_OUTPUT, PUSH)){//mA output button pressed                                                                            
                                            lcd.nexChgPage(PAGE_33_MA_OUT);//display    
                                            lcd.nexSendTxt("title33","4-20mA Output scale");     
                                            lcd.nexSendTxt("info1","Pin 3: Full scale 0 to 125 RPM");                                                    
                                            lcd.nexSendTxt("info2","Pin 3: Match input scale");  

                                            if(nvm._4_20mAoutPut == _4_20MA_OUT_FULL_SCALE){                                                
                                                lcd.nexSetDSBtn("bt1", UNTICK);//display 
                                                lcd.nexSetDSBtn("bt0", TICK);//display                                                  
                                            }
                                            else
                                            if(nvm._4_20mAoutPut == _4_20MA_OUT_MATCH_INPUT_SCALE){
                                                lcd.nexSetDSBtn("bt1", TICK);//display 
                                                lcd.nexSetDSBtn("bt0", UNTICK);//display 
                                            }                                            
                                        }                                                     
                                        else
                                        if(touchBtn(PAGE_35_CONT_SET, P35_SPEED_LIMIT, PUSH)){//Speed limit button pressed   
                                            lcd.nexChgPage(PAGE_31_SPEED_LIMIT); 
                                            //speedLimit = 

                                        }
                                        else
                                        if(touchBtn(PAGE_35_CONT_SET, P35_RUN_HOURS, PUSH)){//Run hours button pressed   
                                            lcd.nexChgPage(PAGE_11_RESET);
                                            lcd.nexSendTxt("title11","Run Hours");  
                                            lcd.nexSendTxt("btn","RESET");                                                  
                                            lcd.nexSendTxt("info1","159");          
                                            lcd.nexSendTxt("info5","Hours"); 
                                            bool runHours = 1;
                                            bool volCntr = 0;                                                                                                                    
                                        }                                        
                                        else
                                        if(touchBtn(PAGE_35_CONT_SET, P35_VOLUME_CNTR, PUSH)){//Reset flow counter button pressed   
                                            lcd.nexChgPage(PAGE_11_RESET);
                                            lcd.nexSendTxt("title11","Volume Counter");  
                                            lcd.nexSendTxt("btn","RESET");                                                  
                                            lcd.nexSendTxt("info1","60");          
                                            lcd.nexSendTxt("info5","Litres");     
                                            bool runHours = 0;
                                            bool volCntr = 1;                                                                                    
                                        }                                        
                                        else
                                        if(touchBtn(PAGE_35_CONT_SET, P35_SCALE_FACTOR, PUSH)){   

                                        }                                                                               
                                        break;

        case PAGE_36_CONT_ADJ:        
                                        ///////////////////////////////////////////////////////////////////////////////
                                        // PAGE 36 CONTROL SETTINGS ADJUSTMENT
                                        ///////////////////////////////////////////////////////////////////////////////     
                                        if(touchBtn(PAGE_36_CONT_ADJ, P36_DEC, PUSH)){   
                                            dispList(i, INC, menuStringID, menuStringArray, P36_MENU_ITEMS);
                                            //pc.printf("\r\n\r\nx = 0x%X, y = 0x%X, z = 0x%X, ",i[x],i[y],i[z]);   
                                        }                                                                                                                         
                                        else
                                        if(touchBtn(PAGE_36_CONT_ADJ, P36_INC, PUSH)){   
                                            dispList(i, DEC, menuStringID, menuStringArray, P36_MENU_ITEMS);                                                                                      
                                            //pc.printf("\r\n\r\nx = 0x%X, y = 0x%X, z = 0x%X, ",i[x],i[y],i[z]); 
                                        }
                                        else      
                                        if(touchBtn(PAGE_36_CONT_ADJ, P36_LOW, PUSH)){//Low button pressed
                                            if(menuStringID == OUTPUT1_LIST){//Output 1 selected                             
                                                lcd.nexSetDSBtn("bt1", UNTICK);//Untick High
                                                lcd.nexSetDSBtn("bt0", TICK);//Tick Low
                                                nvm.outPut1Logic = OUT1_LOGIC_LO;//Set Low for output 1 in global structure
                                                writeNVMByte(NVM_OUTPUT1_LOGIC,nvm.outPut1Logic);//write Low for output 1 to NVM                                                                                          
                                            }
                                            else 
                                            if(menuStringID == OUTPUT2_LIST){//Output 2 selected                                                                            
                                                lcd.nexSetDSBtn("bt1", UNTICK);//Untick High
                                                lcd.nexSetDSBtn("bt0", TICK);//Tick Low
                                                nvm.outPut2Logic = OUT2_LOGIC_LO;//Set Low for output 2 in global structure 
                                                writeNVMByte(NVM_OUTPUT2_LOGIC,nvm.outPut2Logic);//write Low for output 2 to NVM                                                     
                                            }
                                        }       
                                        else
                                        if(touchBtn(PAGE_36_CONT_ADJ, P36_HIGH, PUSH)){//High button pressed 
                                           if(menuStringID == OUTPUT1_LIST){//Output 1 selected                                              
                                                lcd.nexSetDSBtn("bt0", UNTICK);//Untick Low
                                                lcd.nexSetDSBtn("bt1", TICK);//Tick High
                                                nvm.outPut1Logic = OUT1_LOGIC_HI;//Set High for output 1 in global structure  
                                                writeNVMByte(NVM_OUTPUT1_LOGIC,nvm.outPut1Logic);//write High for output 1 to NVM                                                                                           
                                            }
                                            else 
                                            if(menuStringID == OUTPUT2_LIST){//Output 2 selected                                     
                                                lcd.nexSetDSBtn("bt0", UNTICK);//Untick Low
                                                lcd.nexSetDSBtn("bt1", TICK);//Tick High
                                                nvm.outPut2Logic = OUT2_LOGIC_HI;//Set High for output 2 in global structure  
                                                writeNVMByte(NVM_OUTPUT2_LOGIC,nvm.outPut2Logic);//write High for output  to NVM                                                    
                                            }                                        
                                        }
                                        else
                                        if(touchBtn(PAGE_36_CONT_ADJ, P36_OK, PUSH)){              

                                            lcd.nexSetFontCol("data", GREEN);

                                            switch(menuStringID){      
                                                case OUTPUT1_LIST:                                                                  
                                                                    nvm.outPut1 = uOutPut1_ID[i[y]]; 
                                                                    writeNVMByte(NVM_OUTPUT1,nvm.outPut1);
                                                                    break;

                                                case OUTPUT2_LIST:  
                                                                    nvm.outPut2 = uOutPut2_ID[i[y]]; 
                                                                    writeNVMByte(NVM_OUTPUT2,nvm.outPut2);
                                                                    break;                                                                                        
                                            }                                                         
                                            //task = retLastStoredTask(savedTask);                                      
                                        }        
                                        break;                                
    }
    return(task);
}

///////////////////////////////////////////////////////////////////////////////
// SCAN NEXTION TOUCH KEYS
///////////////////////////////////////////////////////////////////////////////
uint8_t nexKeyScan(uint8_t presentTask, uint8_t savedTask){
/*
    Do not place any delays or function that take too much time as this is an ISR message service, use a flag in the main routing instead
 */

/*
    Nextion RX interrupt sets the keyScanFlag
    when a touch key command has been received
    the switch below filters which Nextion page 
    has sent the command
*/
    static uint8_t task = presentTask;

    if(task != ANA_CAL)
        task = presentTask;

    if(keyScanFlag == true){//RX ISR sets this flag
        keyScanFlag = false;
        task = nexPage(presentTask, savedTask);      
    } 
    return(task);//return back to the present task or next task                                          
}
