
#ifndef FUNCTIONS_H
#define FUNCTIONS_H

#include "mbed.h"
#include "Definitions.h"

extern Thread thread;
extern volatile uint16_t loopTime; 
extern volatile bool loopTimeFlag;
extern volatile bool readFlag;

extern uint8_t pumpType;
extern const uint8_t uOutPut1_ID[7];
extern const uint8_t uOutPut2_ID[7];
extern const uint8_t uFlowUnitID[10];
extern const string sFlowUnits[];
extern const float fMaxFlowUnits[][10];
extern const float fMinFlowUnits[][10];

extern const string menuStringArray[][10];

extern bool incFlag;
extern bool decFlag;
extern bool okFlag;
extern bool manFlag;

extern uint8_t calState;

uint8_t decodeByteNVM(uint8_t nvmByte, uint8_t *prec);

char* itoa(int num, char* str, int base);  
long mapI(long x, long in_min, long in_max, long out_min, long out_max);
float mapF(float in, float inMin, float inMax, float outMin, float outMax);
void nexScrnUpdate(void);
void dbgNextion(void);
void eepromTesting(void);
void infoScrn(void);
void NVM_update_Thread(void);

void nexInit(uint32_t baud);
float low_pass_filterF(float x);
void keyScan(void);
float flowUnitPrec(int8_t precision);
uint8_t runModeNVM(uint8_t settingIndex);
void dbgStates(uint8_t state);
uint8_t touchBtn(uint8_t nexPage, uint8_t nexBtn, uint8_t nexPushPop);
uint8_t anaCal(void);
float incDecControl(float *val, float precision, float min, float max, float speedLimit);
bool drawCalGraph(float x1, float y1, float x2, float y2,bool draw);
uint8_t retLastStoredTask(uint8_t storedTask);
void flowUnitInc(uint8_t *flowUx, uint8_t *flowUy, uint8_t *flowUz);
void flowUnitDec(uint8_t *flowUx, uint8_t *flowUy, uint8_t *flowUz);
void dispList(uint8_t i[3], uint8_t incDec, uint8_t stringList, const string sArray[2][10], uint8_t maxListStrings);
uint8_t ReadListIndexNVM(uint8_t nvm);
void loopTimeMeasure(void);
float motorRPM(void);

#endif
