#ifndef DEFINITIONS_H 
#define DEFINITIONS_H 

#include "mbed.h"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// NEPTUNE DEFINITIONS
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//#define BOOTLOADER
//#define WDT_TEST
//#define DEBUG_STATES
//#define LOOP_TIME
#define DEBUG_LCD
#define DEBUG_NVM
#define DEBUG_FUNCTIONS

#define MV(x)   ((0xFFFF*X)/3300)

enum STATES{INITIALISE,START,STOP,STOP_SCRN,RUNNING,ANALOGUE_SET,DOSE,MANUAL_SET,PROFIBUS,STALL,
                DEBUG,DIAGS,ALARM,FAULT,READ_KEYS,MANUAL_MODE,ANALOGUE_MODE,PROFIBUS_MODE,
                CONTACT_SET,FLUIDREC_SET,READ_NVM,RESET_VARS,ANA_CAL,MAX,REMOTE_IN,FLOW_CAL_SET};

enum ANACAL{CAL1_SCRN, CAL2_SCRN, CAL3_SCRN, CAL4_SCRN, COMPLETE_SCRN, EXIT};

///////////////////////////////////////////
// DEBUG
//////////////////////////////////////////
#define HEX 0
#define STR 1
#define CHR 3

///////////////////////////////////////////
// NEPTUNE TYPE
//////////////////////////////////////////
#define QDOS_30                 0
#define VDOS_20                 1
#define VDOS_30                 2
#define VDOS_60                 3
#define VDOS_120                4

///////////////////////////////////////////
// WATCHDOG
//////////////////////////////////////////
#define WDT                     1.0//Seconds

///////////////////////////////////////////
// METER DISPLAY
//////////////////////////////////////////
#define METER_ZERO              0.00001

///////////////////////////////////////////
// PWM CONSTANTS
//////////////////////////////////////////
#define PWM_PERIOD              100.0//100us
#define MOTOR_PWM_MIN           0.000
#define MOTOR_PWM_MAX           100.0
#define PWM_PRESCALER           1
#define ZERO                    0

///////////////////////////////////////////
// MOTOR / GEARBOX CONSTANTS
//////////////////////////////////////////
#define MOTOR_RPM_MIN           3.2//Motor RPM based on QDOS 20, 32:1 gearbox ratio
#define MOTOR_RPM_MAX           55//Motor RPM based on QDOS 20, 32:1 gearbox ratio

///////////////////////////////////////////
// INC/DEC BUTTON SPEED CONSTANTS
//////////////////////////////////////////
#define START_DELAY             0.5//Delay before INC/DEC starts to operate
#define DELAY_SHORT             0.5//Delay before INC/DEC of SLOW_SPEED when < DELAY_LONG
#define DELAY_LONG              4.0//After DELAY_LONG switch to FAST_SPEED
#define SLOW_SPEED              0.25
#define FAST_SPEED              0.02

///////////////////////////////////////////
// MOTOR CONSTANTS
//////////////////////////////////////////
#define ARROW_ROTATION_SPEED    150//Milliseconds
#define CCW                     0
#define CW                      1 
#define MOTOR_ENABLE            1
#define MOTOR_DISABLE           0
#define BRAKE_ON                0
#define BRAKE_OFF               1
#define MOT_STALL               1
#define MOT_FAULT               2
#define INDICATORS_ONLY         1
#define BTN_AND_IND             0
#define BTN_BYPASS_TRUE         1
#define BTN_BYPASS_FALSE        0

///////////////////////////////////////////
// MOTOR CONTROL CONSTANTS
//////////////////////////////////////////
#define MOT_RAMP_1_SEC          0.3

///////////////////////////////////////////
// ANALOGUE INPUT CONSTANTS
//////////////////////////////////////////
#define ADC_SAMPLES             500//Min sample size is 50, when on PCB I expect to be alble to lower this sample size due to less noise

///////////////////////////////////////////
// ANALOGUE INPUT/OUTPUT CONSTANTS
//////////////////////////////////////////
#define HYST_MA                 0.05
#define I_0MA                   0.00
#define I_3MA                   3.00
#define I_4MA                   4.00
#define I_4_1MA                 4.10
#define I_19_8MA                19.80
#define I_20MA                  20.00
#define I_21MA                  21.00
#define I_22_4MA                22.40

///////////////////////////////////////////
// ANALOGUE INPUT/OUTPUT CALIBRATION CONSTANTS
//////////////////////////////////////////
#define DAC_V_HIGH              (0.3030*3.0000)//factor * V
#define DAC_V_LOW               (0.3030*0.4450)//factor * V

#define ADC_MIN_V               0.01250//[05/11/19] 4.00, accurate on this day, 13:30
#define ADC_MAX_V               3.31200//[05/11/19] 20.00, accurate on this day, 13:30
#define VDD                     3.30

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// NEXTION
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////
// NEXTION  CONSTANTS
//////////////////////////////////////////
#define FLOW_U_STRING_LIST      0
#define OUTPUT_STRING_LIST      1

#define OUTPUT1_LIST            1//uses the same list items indexer (1) for output 1 & 2   
#define OUTPUT2_LIST            2//uses the same list items indexer (1) for output 1 & 2     
#define MA_OUTPUT_LIST          3     

#define ADJ_FLOW_UNITS          1
#define ADJ_CONT_SET            2

#define P8_MENU_ITEMS           9
#define P36_MENU_ITEMS          6

//NEXTION PAGES
#define PAGE_0                  0
#define PAGE_1_HOME             1
#define PAGE_2_INFO             2
#define PAGE_3_MAIN             3
#define PAGE_5_FLUID_LEV_SET    5
#define PAGE_7_FLUID_LEV_SET    7
#define PAGE_8_FLOWU_ADJ        8
#define PAGE_9_SETTINGS         9    
#define PAGE_12_MODE            12  
#define PAGE_11_RESET           11 
#define PAGE_14_ANA_CAL         14
#define PAGE_18_ANA_CAL_MODE    18
#define PAGE_27_ABOUT           27
#define PAGE_31_SPEED_LIMIT     31
#define PAGE_33_MA_OUT          33
#define PAGE_34_START_STOP      34
#define PAGE_35_CONT_SET        35

#define PAGE_36_CONT_ADJ        36

#define CLEAR_INC_DEC           35
//EVENTS 
#define TOUCH_EVENT             0x65   

//RX ARRAY
#define PAGE                    1//element 1
#define ID                      2//element 2  
#define PUSHPOP                 3//element 3

#define PUSH                    1
#define POP                     0

///////////////////////////////////////////////////////////////////////////////
// NEXTION CONSTANTS
///////////////////////////////////////////////////////////////////////////////

//ANALOGUE CALIBRATION DRAWLINE COORDINATES
#define X1                      70
#define Y1                      182
#define X2                      196
#define Y2                      57

#define DRAW_SPEED              50

#define DRAW                    1
#define ERASE                   0

//DEFAULT FACTORY SETTINGS
#define LOW_CAL_MIN             3.00
#define LOW_CAL_DEF             4.10
#define HIGH_CAL_DEF            19.80
#define HIGH_CAL_MAX            21.00

///////////////////////////////////////////////////////////////////////////////
// NEXTION COMPONENT IDs
///////////////////////////////////////////////////////////////////////////////

//PAGE 1 HOME COMPONENT IDs
#define P1_INC                  7//Inc key
#define P1_DEC                  8//Dec key
#define P1_MAX                  11
#define P1_SET                  12
#define P1_MENU                 13
#define P1_MODE                 14

//PAGE 3 MAIN MENU IDs
#define P3_FLUID_LEV_MON        5
#define P3_SECURITY             6
#define P3_CONT_SETTINGS        4
#define P3_INFO                 3
#define P3_BACK                 1

//PAGE 5 FLUID LEVEL SETTINGS MENU IDs
#define P5_BACK                 1  
#define P5_HOME                 2  

//PAGE 5 FLUID LEVEL SETTINGS IDs
#define P5_DISABLE              7
#define P5_CON_LEV_MON          3
#define P5_ADJ_LEV              4
#define P5_US_GALS              5    
#define P5_LITRES               6              

//PAGE 7 FLUID LEVEL SETTINGS IDs
#define P7_BACK                 1
#define P7_HOME                 2
#define P7_ENABLE               3

//PAGE 8 IDs
#define P8_INC                  4
#define P8_DEC                  5
#define P8_OK                   6
#define P8_HOME                 9
#define P8_BACK                 1  

//PAGE 9 SETTINGS COMPONENT IDs
#define P9_AUTO_RESTART         3
#define P9_FLOW_UNITS           4
#define P9_ASS_NUM              5
#define P9_PUMP_LAB             6
#define P9_RESTORE              7    
#define P9_LANG                 8
#define P9_BACK                 1  

//PAGE 11 IDs
#define P11_OK                  4

//PAGE 12 MODE COMPONENT IDs
#define P11_RESET               3
#define P11_BACK                1

//PAGE 12 MODE COMPONENT IDs
#define P12_MANUAL              3
#define P12_FLOW_CAL            4
#define P12_ANALOGUE            5
#define P12_CONTACT             6    
#define P12_FLUID_REC           7
#define P12_ANA_CAL             8
#define P12_BACK                1  

//PAGE 14 4-20mA CAL COMPONENT IDs
#define P14_INC                 3
#define P14_DEC                 4
#define P14_OK                  5
#define P14_BACK                1    

//Page 18 4-20mA CAL COMPONENT IDs
#define P18_MAN                 5
#define P18_INPUT               6
#define P18_BACK                8

//Page 27 COMPONENT IDs
#define P27_BACK                7    

//Page 31 SPEED LIMIT COMPONENT IDs
#define P31_INC                 2
#define P31_DEC                 3
#define P31_OK                  4
#define P31_HOME                6 
#define P31_BACK                5

//Page 33 START/STOP INPUT COMPONENT IDs
#define P33_MATCH               5
#define P33_FULL_SCALE          4
#define P33_HOME                7
#define P33_BACK                6

//Page 34 START/STOP INPUT COMPONENT IDs
#define P34_HIGH                2
#define P34_LOW                 3
#define P34_HOME                4 
#define P34_BACK                5

//Page 35 CONTROL SETTINGS COMPONENT IDs
#define P35_INPUT               3
#define P35_OUTPUT1             4
#define P35_OUTPUT2             5
#define P35_MA_OUTPUT           6
#define P35_SPEED_LIMIT         8
#define P35_RUN_HOURS           9
#define P35_VOLUME_CNTR         10
#define P35_SCALE_FACTOR        11
#define P35_HOME                7
#define P35_BACK                2  

//Page 36 CONTROL SETTINGS ADJ COMPONENT IDs
#define P36_INC                 1
#define P36_DEC                 2
#define P36_OK                  3
#define P36_LOW                 5
#define P36_HIGH                6    
#define P36_BACK                7

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// NVM
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*
    NVM MEMORY MAP LOCATIONS

    Flow Units                      : 0x00         : 1 byte
    Run Mode                        : 0x01         : 1 byte
    Auto Restart                    : 0x02         : 1 byte
    Pump Head Failure               : 0x03         : 1 byte
    Alarm                           : 0x04         : 1 byte
         
    4-20mA Low Val Calibration      : 0x0A - 0x0B  : two bytes 16 bits
    4-20mA High Val Calibration     : 0x0C - 0x0F  : two bytes 16 bits    
*/

//NVM CONSTANTS
#define NVM_INIT                0x00

//Auto Restart
#define DISABLED                0x20
#define ENABLED                 0x21

//Pump Head Failure
#define HEAD_OK                 0x30
#define HEAD_FAIL               0x31

#define NVM_UN_USED             0xff

//NVM CONSTANTS
#define NVM_START               0
#define NVM_INIT                0x00
#define NVM_UN_USED             0xff

///////////////////////////////////////////
// EEPROM CONSTANTS
//////////////////////////////////////////
#define SPI_FREQ                10000000//SPI Frequency in Hz  
#define BYTE_SIZE               128//Organised 128 x 8 = 1024
#define PAGE_SIZE               16//64 pages

#define NVM_SIZE                64//Initial size until further notice

#define BLANK                   0xff
#define INIT                    0x00

//NVM BYTE MEMORY LOCATIONS 
#define NVM_START_ADDR          0

#define NVM_FLOW_UNITS          0//uint8_t 1 byte
#define NVM_RUN_MODE            1//uint8_t 1 byte
#define NVM_AUTO_RESTART        2//uint8_t 1 byte
#define NVM_PUMP_HEAD_STATUS    3//uint8_t 1 byte
#define NVM_ALARM_OUTPUT        4//uint8_t 1 byte
#define NVM_HEAD_SIDE           5//uint8_t 1 byte
#define PUMP_ON_OFF             6//uint8_t 1 byte
#define SPARE                   7//uint8_t 1 byte 
#define NVM_SPEED_LIMIT         8//float value 4 bytes
#define NVM_FLOWU_VAL           12//float value 4 bytes
#define NVM_ANA_MA_CAL_LOW      16//float value 4 bytes
#define NVM_ANA_MA_CAL_HIGH     20//float value 4 bytes
#define NVM_ANA_FLOW_CAL_LOW    24//float value 4 bytes
#define NVM_ANA_FLOW_CAL_HIGH   28//float value 4 bytes
#define NVM_ADC_V_MIN           32//float value 4 bytes
#define NVM_ADC_V_MAX           36//float value 4 bytes
#define NVM_DAC_V_LOW           40//float value 4 bytes   
#define NVM_DAC_V_HIGH          44//float value 4 bytes
#define NVM_RMT_STOP_PUMP       48//uint8_t 1 byte
#define NVM_OUTPUT1             49//uint8_t 1 byte
#define NVM_OUTPUT1_LOGIC       50//uint8_t 1 byte
#define NVM_OUTPUT2             51//uint8_t 1 byte
#define NVM_OUTPUT2_LOGIC       52//uint8_t 1 byte
#define NVM_4_20MA_OUT          53//uint8_t 1 byte

///////////////////////////////////////////
// NVM FLOW UNIT CONSTANTS
//////////////////////////////////////////
#define FLOW_UNITS              0x01
#define PERCENT                 0x10
#define GPD                     0x11
#define GPH                     0x12
#define ML_HR                   0x13
#define ML_MIN                  0x14
#define L_DAY                   0x15
#define L_HR                    0x16
#define L_MIN                   0x17
#define OZ_MIN                  0x18
#define RPM                     0x19

///////////////////////////////////////////
// NVM RUN MODE CONSTANTS
//////////////////////////////////////////
#define MANUAL                  0x20
#define ANALOGUE                0x21
#define CONTACT                 0x22
#define FLUID_REC               0x23
#define FLOW_CAL                0x24

///////////////////////////////////////////
// NVM AUTO RESTART CONSTANTS
//////////////////////////////////////////
#define AUTO_RESTART_OFF        0x30
#define AUTO_RESTART_ON         0x31

///////////////////////////////////////////
// NVM PUMP HEAD CONSTANTS
//////////////////////////////////////////
#define PUMP_HEAD_FAIL          0x40
#define PUMP_HEAD_OK            0x41

///////////////////////////////////////////
// NVM ALARM CONSTANTS
//////////////////////////////////////////
#define ALARM_OFF               0x50
#define ALARM_ON                0x51

///////////////////////////////////////////
// NVM HEAD SIDE CONSTANTS
//////////////////////////////////////////
#define HEAD_LEFT               0x60
#define HEAD_RIGHT              0x61

///////////////////////////////////////////
// NVM PUMP ON/OFF CONSTANTS
//////////////////////////////////////////
#define PUMP_OFF                0x70
#define PUMP_ON                 0x71

///////////////////////////////////////////
// NVM REMOTE START/STOP CONSTANTS
//////////////////////////////////////////
#define RMT_STOP_PUMP_LOW       0x80
#define RMT_STOP_PUMP_HIGH      0x81

///////////////////////////////////////////
// NVM OUTPUT1 CONSTANTS
//////////////////////////////////////////
#define OUT1_GENERAL_ALARM      0x90
#define OUT1_RUN_STATUS         0x91
#define OUT1_MANUAL_MODE        0x92
#define OUT1_ANALOGUE_MODE      0x93
#define OUT1_CONTACT_MODE       0x94
#define OUT1_FLUID_LEVEL        0x95
#define OUT1_LEAK_DETECT        0x96

///////////////////////////////////////////
// NVM OUTPUT1 LOGIC CONSTANTS
//////////////////////////////////////////
#define OUT1_LOGIC_HI           0x97
#define OUT1_LOGIC_LO           0x98

///////////////////////////////////////////
// NVM OUTPUT2 CONSTANTS
//////////////////////////////////////////
#define OUT2_GENERAL_ALARM      0xA0
#define OUT2_RUN_STATUS         0xA1
#define OUT2_MANUAL_MODE        0xA2
#define OUT2_ANALOGUE_MODE      0xA3
#define OUT2_CONTACT_MODE       0xA4
#define OUT2_FLUID_LEVEL        0xA5
#define OUT2_LEAK_DETECT        0xA6

///////////////////////////////////////////
// NVM OUTPUT2 LOGIC CONSTANTS
//////////////////////////////////////////
#define OUT2_LOGIC_HI           0xA7
#define OUT2_LOGIC_LO           0xA8

///////////////////////////////////////////
// NVM 4-20mA CONSTANTS
//////////////////////////////////////////
#define _4_20MA_OUT_FULL_SCALE          0xB0
#define _4_20MA_OUT_MATCH_INPUT_SCALE   0xB1

///////////////////////////////////////////
// NVM SPEED LIMIT CONSTANTS
//////////////////////////////////////////
#define MAX_SPEED_LIMIT                 125.0

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// NUCLEO-F746ZG PIN ASSIGNMENTS
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////
// SHAFT ENCODER
//////////////////////////////////////////
#define USB_BOOTLOAD            PF_11//Output to set Bootload mode

///////////////////////////////////////////
// SHAFT ENCODER
//////////////////////////////////////////
#define A                       PG_10//Schematic Checked 051219  
#define B                       PG_11//Schematic Checked 051219  
#define I                       PG_12//Schematic Checked 051219  

///////////////////////////////////////////
// POWER GOOD SIGNAL
//////////////////////////////////////////
#define PWR_GOOD                PD_0

///////////////////////////////////////////
// LEAK DETEDCT INPUT
//////////////////////////////////////////
#define LEAK_DETECT_INPUT       PD_1//Schematic Checked 051219 

///////////////////////////////////////////
// REMOTE CONTROL INPUTS
//////////////////////////////////////////
#define RUN_STOP                PB_3//Schematic Checked 051219
#define EXT_CONT                PB_4//Schematic Checked 051219 
#define RMT_FLD_REC             PB_5//Schematic Checked 051219 

///////////////////////////////////////////
// 4-20mA CONTROL OUTPUTS
//////////////////////////////////////////
#define ALARM_OUT1              PC_7//Schematic Checked 051219 
#define ALARM_OUT2              PA_15//Schematic Checked 051219 

///////////////////////////////////////////
// (ADC1/3) 4-20mA ANALOGUE INPUT
//////////////////////////////////////////
#define ANA_IN_A0               PA_3//Schematic Checked 051219 

///////////////////////////////////////////
// (DAC1/1) 4-20mA ANALOGUE OUTPUT
//////////////////////////////////////////
#define ANA_OUT_DAC1            PA_4//Schematic Checked 

///////////////////////////////////////////
// SPI (SPI4)
//////////////////////////////////////////
#define SCLK                    PE_2//Schematic Checked 051219 
#define SSEL                    PE_4//Schematic Checked 051219 
#define MISO                    PE_5//Schematic Checked 051219 
#define MOSI                    PE_6//Schematic Checked 051219 

///////////////////////////////////////////
// BUTTON MEMBRANE INDICATOR 
//////////////////////////////////////////
#define START_LED               PC_6//Schematic Checked 051219 
#define STOP_LED                PB_12//Schematic Checked 051219 

#define STOP_BTN                PB_13//Schematic Checked, grey box build only 
#define START_BTN               PB_15//Schematic Checked, grey box build only 


///////////////////////////////////////////
// MOTOR CONTROL / ALARMS 
//////////////////////////////////////////
#define MOT_EN                  PB_11//MOVED_280220 
#define MOT_DIR                 PB_10//MOVED_280220 
#define N_BRK                   PF_15
#define FG_OUT                  PF_13
#define N_FAULT                 PF_14
#define PWM                     PD_15

///////////////////////////////////////////
// NETION POWER CONTROL 
//////////////////////////////////////////
#define NEX_PWR                 PF_12//Schematic Checked 051219 

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// NUCLEO-F746ZG RS232 COMMUNICATION
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*USART

USART1 = VERDERBUS
USART2 = NEXTION DISPLAY
USART3 = BOOTLOADER
USART6 = MOTOR CONTROL

*/


///////////////////////////////////////////
// BAUS RATES
///////////////////////////////////////////
#define SLOW_BAUD               9600
#define MED_BAUD                115200
#define FAST_BAUD               921600

///////////////////////////////////////////
// USART2 NEXTION DISPLAY
///////////////////////////////////////////
#define USART2_TX               PD_5
#define USART2_RX               PD_6

///////////////////////////////////////////
// USART6 ED MOTOR CONTROL
///////////////////////////////////////////
#define USART6_TX               PG_14
#define USART6_RX               PG_9

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// VERDERBUS EXPANSION
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define USART1_TX               PA_9//Schematic Checked 051219
#define USART1_RX               PA_10//Schematic Checked 051219 
#define SPI5_SSEL               PF_6//Schematic Checked 051219  
#define SPI5_SCK                PF_7//Schematic Checked 051219  
#define SPI5_MISO               PF_8//Schematic Checked 051219  
#define SPI5_MOSI               PF_9//Schematic Checked 051219  
#define ADC1_1                  PA_1//Schematic Checked 051219  
#define ADC1_2                  PA_2//Schematic Checked 051219  
#define DAC1_2                  PA_5//Schematic Checked 051219  
#define VBD0                    PG_0
#define VBD1                    PG_1
#define VBD2                    PG_2
#define VBD3                    PG_3
#define VBD4                    PG_4//Schematic Checked 051219 
#define VBD5                    PG_5//Schematic Checked 051219 
#define VBD6                    PG_6//Schematic Checked 051219 
#define VBD7                    PG_7//Schematic Checked 051219 
#define PWM3_3                  PC_8//Schematic Checked 051219    

#endif  /* DEFINITIONS_H */
