#include "mbed.h"
#include "MotorControl.h"

RawSerial mc_usart(PA_2,PA_15,115200);// this will be USART6 for motor control 

const string rxMsgTable[MESSAGE] = {

    "SET DRIVE WORKING SETINGS",
    "SET FEEDBACK BOOST CURRENT",    
    
};

struct drvWorkingSettings{
 
 bool par0;
 bool par1;
 bool par2;
 bool par3;
 bool feedBackMotChk;
 bool par5;
 bool auomaticMotCurRed;
 bool disableDigOutputsFWH;
 bool par8; 
 bool par9;
 bool motRotDir;
 bool par11;
 bool par12; 
 bool fbErrMotAct;
 bool par14;
 bool par15;  
  
};

char rxMsgStore[BUFFER_SIZE];//received local message store
char mc_Tx_Buffer[BUFFER_SIZE];//transmitted message buffer 
volatile char mc_Rx_Buffer[BUFFER_SIZE];//received message buffer
volatile unsigned char mc_Rx_Rd_Ptr = 0;//circulare buffer read pointer
volatile unsigned char mc_Rx_Wr_Ptr = 0;//circulare buffer write pointer
unsigned int rx_int = 0;//received integer / character

//unsigned char i; 
bool msgRecFlag = false;//message received flag 

void motMsg_RX_ISR(void){
    
    //led1=1;
    //save character in buffer
    mc_Rx_Buffer[mc_Rx_Wr_Ptr] = mc_usart.getc();
    //increment pointer
    mc_Rx_Wr_Ptr++;
    //test for wrap around
    if(mc_Rx_Wr_Ptr == (BUFFER_SIZE - 1))
    {
        mc_Rx_Wr_Ptr = 0;
    }
    //wait(0.0001);
    //led1=0; 
}
  
bool getMotMsg(char * msgArray){
    
    //declare variables
    static unsigned char i;
    unsigned int uiMsg= 0xFFFF;

    //test for any characters in the receiver buffer
    if (mc_Rx_Wr_Ptr != mc_Rx_Rd_Ptr)
    {
        //character in the buffer, return the value
        uiMsg = mc_Rx_Buffer[mc_Rx_Rd_Ptr];
        //increment the Rd pointer
        mc_Rx_Rd_Ptr++;
        //test for wrap around
        if(mc_Rx_Rd_Ptr == (BUFFER_SIZE - 1))
        {
            mc_Rx_Rd_Ptr = 0;
        }
    }
                
    if(uiMsg != 0xFFFF){//check that a character is in the buffer        
        msgArray[i++] = uiMsg;//store characters in local message store array
        
        mc_usart.printf("%c\r\n", uiMsg); 
               
        if(uiMsg == '\r'){//look for <CR> then print out the message in the RX buffer
            
            msgRecFlag = true;//set the message received flag
            
            mc_usart.printf("Stored Message\r\n");
                            
            for(i=0 ; i <BUFFER_SIZE ; i++)                    
                mc_usart.printf("%c\r\n",msgArray[i]);
                
        }
    }
    else
        i=0;    
            
             
    return(msgRecFlag);
} 

void motMsgDecode(unsigned int rxMsgTable[], unsigned int rxMsg[]){
    
    if(memcmp(rxMsgTable, rxMsg, 10)){
        
    }
    
}

void clrRxMsg(char array[]){

    for(unsigned char i=0; i<BUFFER_SIZE; i++)
        array[i]=0;
    
    #ifdef DEBUG    
        mc_usart.printf("Clear the RX local message store\r\n"); 
    #endif
                
    for(unsigned char i=0; i<BUFFER_SIZE; i++){
    
        #ifdef DEBUG
            mc_usart.printf("%c\r\n",array[i]);  
        #endif
    }
} 


bool moveMot(uint8_t par1, int32_t par2){
    
    static uint8_t newPar1 = 0;
    static int32_t newPar2 = 0;    
    bool fault = false;
    
    if((par1 != newPar1) || (par2 != newPar2)){
        
        newPar1 = par1;
        newPar2 = par2;        
        
        if(((par1 >=0) && (par1 <=4))&&((par2 >= REV_MAX_STEPS) && (par2 <= FWD_MAX_STEPS))){  
            sprintf(mc_Tx_Buffer,"MOVEMOT %d %u\r",par1, par2);      
            mc_usart.printf("%s\r",mc_Tx_Buffer);    
        }
        else
            fault = true;
                            
    }
    return(fault);    
}
