
/*

    ED Motor Controller API
    
    
    Notes:
    A robust protocal has been called for, the motor command sent out is to be echoed back with and <ACK> or <NACK>
       
    In order to compare what was sent to what is echoed back two buffers are required, a TX buffer and an RX buffer, they can then be compared 
    using memcmp() function
    
    19/03/20 Compare of tx and rx buffers can be done
    20/03/20 Migrate code to mbed studio



*/

#include "mbed.h"
#include <string> 
#include "MotorControl.h"

DigitalOut led1(LED1);



int main(){
    
    led1=0;
    
    mc_usart.attach(&motMsg_RX_ISR);//start the serial receiver interrupt
    mc_usart.printf("ED Motor Controller Commands\r\n");
       
    clrRxMsg(rxMsgStore);

    moveMot(1, 1000);
    
    mc_usart.printf("TX Buffer Contents\r\n");
    
    for(unsigned char i=0 ; i <BUFFER_SIZE ; i++)                     
        mc_usart.printf("%c\r\n",mc_Tx_Buffer[i]);
  
    while(1){
        
        if(getMotMsg(rxMsgStore)){//get the message from the receive buffer and store it in local message store
            
            msgRecFlag = false;//clear the message received flag
            
            if(memcmp(rxMsgStore,mc_Tx_Buffer,strlen(rxMsgStore)) == 0){
                led1=1;
            }            
        }                      
    }
}