/*
 * Copyright (c) 2018 Yusuke Okino

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#include "dynamixel_servo_controller.h"

int main()
{
    const uint8_t servo_id = 0x01;
    
    dynamixel_servo_v2::XM430 xm430(PA_9, PA_10);

    xm430.Torque_ON(servo_id);

    // 少し待つ処理が必要( サーボからの返答を受信する処理を入れたら不要になる )
    #ifdef MBED_ENVIRONMENT 
        wait(0.1); 
    #endif

    xm430.Set_Pos(servo_id, 999);
    
    
    #ifdef MBED_ENVIRONMENT
    while(1)
    {
        
    }
    #endif

    return 0;
}


