#include "mbed.h"
#include <stdbool.h>
#include <stdint.h>
//#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
//#include <memory.h>


/*

Use pull up resistors
Test Sample I2C with Tiva
Learn about the I2C in freescale boards
Check I2CReceiveData and I2CSendData compatibitily with Tiva
Now Use ROM boot loader
if it works get the flash code from CDMS people and try with that

*/

// BootLoader

Serial pc(USBTX, USBRX); // tx, rx

I2C i2c(D15, D14);

const int addr = 0x42;

#define COMMAND_PING            0x20
#define COMMAND_DOWNLOAD        0x21
#define COMMAND_RUN             0x22
#define COMMAND_GET_STATUS      0x23
#define COMMAND_SEND_DATA       0x24
#define COMMAND_RESET           0x25
#define COMMAND_RET_SUCCESS     0x40
#define COMMAND_RET_UNKNOWN_CMD 0x41
#define COMMAND_RET_INVALID_CMD 0x42
#define COMMAND_RET_INVALID_ADR 0x43
#define COMMAND_RET_FLASH_FAIL  0x44
#define COMMAND_RET_CRC_FAIL    0x45
#define COMMAND_ACK             0xcc
#define COMMAND_NAK             0x33

//*****************************************************************************
//
//! This variable will be set to the starting address of the binary will be
//! programmed into to device.
//

static uint32_t g_ui32DownloadAddress;


//
//! This variable will be set to the start execution address for the binary
//! that is downloaded.
//

static uint32_t g_ui32StartAddress;




uint32_t g_ui32DataSize;
uint8_t g_pui8Buffer[256];

uint8_t CheckSum(uint8_t *pui8Data, uint8_t ui8Size);

//

int 
I2CSendData(uint8_t const *pui8Data, uint8_t ui8Size)
{
   
    int i;
    char temp[ui8Size];
    
    
    
    for(i=0;i<ui8Size;i++)
    {
        
        temp[i] = pui8Data[i];
           
    }
    
    
    if(i2c.write(addr, temp, ui8Size,0) == 0)
    {
        return (0);
    }
    
    
    pc.printf("Write Error\n");
    return (-1);
    
    
}

int
I2CReceiveData(uint8_t *pui8Data, uint8_t ui8Size)
{
   
    int i,stat;
    char temp[ui8Size];
    
    stat = i2c.read(addr, temp, ui8Size,0);
    for(i=0;i<ui8Size;i++)
    {
        
        temp[i] = pui8Data[i];
           
    }
    
    if(stat == 1)
    {
    
    pc.printf("Recieve Error\n");
    return (-1);
    }    
    
    return 0;
}        
 

//****************************************************************************
//
//! AckPacket() sends an Acknowledge a packet.
//!
//! This function acknowledges a packet has been received from the device.
//!
//! \return The function returns zero to indicated success while any non-zero
//! value indicates a failure.
//
//****************************************************************************





int32_t
AckPacket(void)
{
    uint8_t ui8Ack;

    ui8Ack = COMMAND_ACK;
    return(I2CSendData(&ui8Ack, 1));
}


//
//! NakPacket() sends a No Acknowledge packet.
//!
//! This function sends a no acknowledge for a packet that has been
//! received unsuccessfully from the device.
//!
//! \return The function returns zero to indicated success while any non-zero
//! value indicates a failure.
//

int32_t
NakPacket(void)
{
    uint8_t ui8Nak;

    ui8Nak = COMMAND_NAK;
    return(I2CSendData(&ui8Nak, 1));
}


//
//! GetPacket() receives a data packet.
//!
//! \param pui8Data is the location to store the data received from the device.
//! \param pui8Size is the number of bytes returned in the pui8Data buffer that
//! was provided.
//!
//! This function receives a packet of data from UART port.
//!
//! \returns The function returns zero to indicated success while any non-zero
//! value indicates a failure.
//

int32_t
GetPacket(uint8_t *pui8Data, uint8_t *pui8Size)
{
    uint8_t ui8CheckSum;
    uint8_t ui8Size;

    //
    // Get the size and the checksum.
    //
    do
    {
        if(I2CReceiveData(&ui8Size, 1))
        {
            return(-1);
        }
    }
    while(ui8Size == 0);

    if(I2CReceiveData(&ui8CheckSum, 1))
    {
        return(-1);
    }
    *pui8Size = ui8Size - 2;

    if(I2CReceiveData(pui8Data, *pui8Size))
    {
        *pui8Size = 0;
        return(-1);
    }

    //
    // Calculate the checksum from the data.
    //
    if(CheckSum(pui8Data, *pui8Size) != ui8CheckSum)
    {
        *pui8Size = 0;
        return(NakPacket());
    }

    return(AckPacket());
}


//
//! CheckSum() Calculates an 8 bit checksum
//!
//! \param pui8Data is a pointer to an array of 8 bit data of size ui8Size.
//! \param ui8Size is the size of the array that will run through the checksum
//!     algorithm.
//!
//! This function simply calculates an 8 bit checksum on the data passed in.
//!
//! \return The function returns the calculated checksum.
//

uint8_t
CheckSum(uint8_t *pui8Data, uint8_t ui8Size)
{
    int32_t i;
    uint8_t ui8CheckSum;

    ui8CheckSum = 0;

    for(i = 0; i < ui8Size; ++i)
    {
        ui8CheckSum += pui8Data[i];
    }
    return(ui8CheckSum);
}


//
//! SendPacket() sends a data packet.
//!
//! \param pui8Data is the location of the data to be sent to the device.
//! \param ui8Size is the number of bytes to send from puData.
//! \param bAck is a boolean that is true if an ACK/NAK packet should be
//! received in response to this packet.
//!
//! This function sends a packet of data to the device.
//!
//! \returns The function returns zero to indicated success while any non-zero
//!     value indicates a failure.
//

int32_t
SendPacket(uint8_t *pui8Data, uint8_t ui8Size, bool bAck)
{
    uint8_t ui8CheckSum;
    uint8_t ui8Ack;

    ui8CheckSum = CheckSum(pui8Data, ui8Size);

    //
    // Make sure that we add the bytes for the size and checksum to the total.
    //
    ui8Size += 2;

    //
    // Send the Size in bytes.
    //
    if(I2CSendData(&ui8Size, 1))
    {
        return(-1);
    }

    //
    // Send the CheckSum
    //
    if(I2CSendData(&ui8CheckSum, 1))
    {
        return(-1);
    }

    //
    // Now send the remaining bytes out.
    //
    ui8Size -= 2;

    //
    // Send the Data
    //
    if(I2CSendData(pui8Data, ui8Size))
    {
        return(-1);
    }

    //
    // Return immediately if no ACK/NAK is expected.
    //
    if(!bAck)
    {
        return(0);
    }

    //
    // Wait for the acknowledge from the device.
    //
    do
    {
        if(I2CReceiveData(&ui8Ack, 1))
        {
            return(-1);
        }
    }
    while(ui8Ack == 0);

    if(ui8Ack != COMMAND_ACK)
    {
        return(-1);
    }
    return(0);
}


int32_t
SendCommand(uint8_t *pui8Command, uint8_t ui8Size)
{
    uint8_t ui8Status;

    //
    // Send the command itself.
    //
    if(SendPacket(pui8Command, ui8Size, 1) < 0)
    {
        return(-1);
    }

    //
    // Send the get status command to tell the device to return status to
    // the host.
    //
    ui8Status = COMMAND_GET_STATUS;
    if(SendPacket(&ui8Status, 1, 1) < 0)
    {
        pc.printf("Failed to Get Status\n");
        return(-1);
    }

    //
    // Read back the status provided from the device.
    //
    ui8Size = sizeof(ui8Status);
    if(GetPacket(&ui8Status, &ui8Size) < 0)
    {
        pc.printf("Failed to Get Packet\n");
        return(-1);
    }
    if(ui8Status != COMMAND_RET_SUCCESS)
    {
        pc.printf("Failed to get download command Return Code: %04x\n",
            ui8Status);
        return(-1);
    }
    return(0);
}

 
    
int main() {
    
    g_ui32DownloadAddress = 0;
    g_ui32StartAddress = 0xffffffff;    
    g_ui32DataSize = 8;
    uint8_t ui8Command;
    
    
    uint32_t ui32TransferLength = 1424;
    uint32_t ui32Offset;
    uint8_t pui8FileBuffer[] = {0 ,  1 ,  0 ,  32 ,  95 ,  5 ,  0 ,  0 ,  109 ,  5 ,  0 ,  0 ,  251 ,  3 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  107 ,  5 ,  0 ,  0 ,  0 ,  42 ,  74 ,  208 ,  95 ,  234 ,  0 ,  12 ,  139 ,  7 ,  28 ,  209 ,  131 ,  7 ,  34 ,  209 ,  16 ,  42 ,  8 ,  211 ,  112 ,  180 ,  16 ,  58 ,  120 ,  201 ,  120 ,  192 ,  16 ,  58 ,  251 ,  210 ,  112 ,  188 ,  16 ,  50 ,  56 ,  208 ,  4 ,  42 ,  44 ,  211 ,  8 ,  42 ,  5 ,  211 ,  12 ,  42 ,  36 ,  191 ,  8 ,  201 ,  8 ,  192 ,  8 ,  201 ,  8 ,  192 ,  8 ,  201 ,  8 ,  192 ,  146 ,  7 ,  42 ,  208 ,  146 ,  15 ,  34 ,  224 ,  11 ,  120 ,  3 ,  112 ,  73 ,  28 ,  64 ,  28 ,  82 ,  30 ,  34 ,  208 ,  139 ,  7 ,  247 ,  209 ,  195 ,  7 ,  20 ,  209 ,  131 ,  7 ,  216 ,  208 ,  18 ,  31 ,  18 ,  211 ,  8 ,  201 ,  3 ,  128 ,  27 ,  12 ,  67 ,  128 ,  0 ,  29 ,  18 ,  31 ,  248 ,  210 ,  10 ,  224 ,  8 ,  201 ,  3 ,  112 ,  27 ,  10 ,  67 ,  112 ,  27 ,  10 ,  131 ,  112 ,  27 ,  10 ,  195 ,  112 ,  0 ,  29 ,  18 ,  31 ,  244 ,  210 ,  18 ,  29 ,  5 ,  208 ,  11 ,  120 ,  3 ,  112 ,  73 ,  28 ,  64 ,  28 ,  82 ,  30 ,  249 ,  209 ,  96 ,  70 ,  112 ,  71 ,  240 ,  181 ,  30 ,  72 ,  1 ,  39 ,  248 ,  66 ,  1 ,  208 ,  0 ,  240 ,  195 ,  248 ,  30 ,  77 ,  30 ,  79 ,  31 ,  78 ,  189 ,  66 ,  6 ,  210 ,  3 ,  205 ,  4 ,  120 ,  164 ,  0 ,  52 ,  89 ,  64 ,  28 ,  160 ,  71 ,  246 ,  231 ,  22 ,  77 ,  22 ,  79 ,  189 ,  66 ,  2 ,  210 ,  16 ,  205 ,  160 ,  71 ,  250 ,  231 ,  240 ,  189 ,  3 ,  37 ,  27 ,  224 ,  65 ,  104 ,  8 ,  48 ,  10 ,  28 ,  42 ,  64 ,  11 ,  209 ,  26 ,  28 ,  42 ,  64 ,  171 ,  67 ,  5 ,  208 ,  4 ,  104 ,  4 ,  48 ,  12 ,  96 ,  4 ,  49 ,  4 ,  59 ,  249 ,  209 ,  19 ,  28 ,  5 ,  208 ,  4 ,  120 ,  1 ,  48 ,  12 ,  112 ,  1 ,  49 ,  1 ,  59 ,  249 ,  209 ,  2 ,  28 ,  42 ,  64 ,  1 ,  208 ,  168 ,  67 ,  4 ,  48 ,  3 ,  104 ,  0 ,  43 ,  224 ,  209 ,  112 ,  71 ,  192 ,  70 ,  255 ,  255 ,  255 ,  255 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  136 ,  5 ,  0 ,  0 ,  144 ,  5 ,  0 ,  0 ,  128 ,  5 ,  0 ,  0 ,  112 ,  181 ,  16 ,  248 ,  1 ,  75 ,  27 ,  224 ,  64 ,  28 ,  90 ,  177 ,  29 ,  10 ,  9 ,  209 ,  2 ,  37 ,  16 ,  248 ,  1 ,  107 ,  109 ,  30 ,  70 ,  234 ,  3 ,  35 ,  249 ,  209 ,  1 ,  224 ,  4 ,  43 ,  2 ,  211 ,  16 ,  248 ,  1 ,  91 ,  3 ,  224 ,  37 ,  70 ,  1 ,  224 ,  1 ,  248 ,  1 ,  91 ,  91 ,  30 ,  179 ,  241 ,  255 ,  63 ,  249 ,  209 ,  1 ,  224 ,  1 ,  248 ,  1 ,  59 ,  16 ,  248 ,  1 ,  59 ,  156 ,  66 ,  249 ,  209 ,  16 ,  248 ,  1 ,  59 ,  0 ,  43 ,  231 ,  209 ,  16 ,  248 ,  1 ,  91 ,  3 ,  120 ,  45 ,  2 ,  91 ,  25 ,  213 ,  209 ,  112 ,  189 ,  254 ,  231 ,  18 ,  72 ,  19 ,  75 ,  32 ,  33 ,  1 ,  96 ,  2 ,  104 ,  18 ,  73 ,  173 ,  241 ,  8 ,  13 ,  0 ,  146 ,  2 ,  32 ,  88 ,  96 ,  0 ,  34 ,  195 ,  248 ,  32 ,  1 ,  24 ,  104 ,  64 ,  240 ,  2 ,  0 ,  24 ,  96 ,  0 ,  146 ,  0 ,  152 ,  129 ,  66 ,  11 ,  216 ,  24 ,  104 ,  32 ,  240 ,  2 ,  0 ,  24 ,  96 ,  0 ,  146 ,  0 ,  152 ,  129 ,  66 ,  239 ,  217 ,  0 ,  152 ,  64 ,  28 ,  0 ,  144 ,  248 ,  231 ,  0 ,  152 ,  64 ,  28 ,  0 ,  144 ,  236 ,  231 ,  8 ,  225 ,  15 ,  64 ,  252 ,  83 ,  2 ,  64 ,  64 ,  13 ,  3 ,  0 ,  78 ,  246 ,  136 ,  81 ,  206 ,  242 ,  0 ,  1 ,  8 ,  104 ,  79 ,  240 ,  240 ,  3 ,  64 ,  234 ,  3 ,  64 ,  8 ,  96 ,  9 ,  72 ,  133 ,  70 ,  9 ,  72 ,  133 ,  68 ,  111 ,  70 ,  7 ,  32 ,  135 ,  67 ,  189 ,  70 ,  7 ,  72 ,  111 ,  70 ,  7 ,  96 ,  255 ,  247 ,  67 ,  255 ,  0 ,  240 ,  79 ,  248 ,  1 ,  32 ,  0 ,  240 ,  48 ,  248 ,  254 ,  231 ,  192 ,  70 ,  0 ,  0 ,  0 ,  32 ,  0 ,  1 ,  0 ,  0 ,  16 ,  1 ,  0 ,  32 ,  112 ,  181 ,  15 ,  77 ,  6 ,  70 ,  115 ,  136 ,  0 ,  36 ,  22 ,  224 ,  160 ,  0 ,  0 ,  235 ,  196 ,  0 ,  48 ,  24 ,  65 ,  104 ,  194 ,  104 ,  128 ,  104 ,  74 ,  185 ,  42 ,  104 ,  82 ,  177 ,  10 ,  120 ,  85 ,  248 ,  34 ,  48 ,  74 ,  28 ,  1 ,  70 ,  16 ,  70 ,  152 ,  71 ,  1 ,  224 ,  255 ,  247 ,  206 ,  254 ,  115 ,  136 ,  100 ,  28 ,  164 ,  178 ,  163 ,  66 ,  230 ,  220 ,  112 ,  189 ,  128 ,  5 ,  0 ,  0 ,  0 ,  191 ,  112 ,  71 ,  8 ,  181 ,  255 ,  247 ,  251 ,  255 ,  254 ,  231 ,  56 ,  181 ,  5 ,  70 ,  9 ,  72 ,  0 ,  104 ,  128 ,  71 ,  9 ,  76 ,  32 ,  29 ,  0 ,  104 ,  16 ,  177 ,  1 ,  70 ,  40 ,  70 ,  136 ,  71 ,  32 ,  104 ,  0 ,  177 ,  128 ,  71 ,  5 ,  72 ,  0 ,  104 ,  128 ,  71 ,  255 ,  247 ,  232 ,  255 ,  56 ,  189 ,  192 ,  70 ,  0 ,  1 ,  0 ,  32 ,  8 ,  1 ,  0 ,  32 ,  4 ,  1 ,  0 ,  32 ,  4 ,  73 ,  177 ,  241 ,  255 ,  63 ,  7 ,  191 ,  0 ,  33 ,  8 ,  28 ,  8 ,  104 ,  9 ,  29 ,  255 ,  247 ,  98 ,  191 ,  255 ,  255 ,  255 ,  255 ,  3 ,  73 ,  8 ,  96 ,  112 ,  71 ,  2 ,  73 ,  9 ,  31 ,  8 ,  96 ,  112 ,  71 ,  112 ,  71 ,  4 ,  1 ,  0 ,  32 ,  208 ,  248 ,  3 ,  32 ,  195 ,  29 ,  8 ,  70 ,  25 ,  70 ,  255 ,  247 ,  135 ,  190 ,  255 ,  247 ,  121 ,  191 ,  112 ,  71 ,  1 ,  34 ,  255 ,  247 ,  25 ,  191 ,  254 ,  231 ,  254 ,  231 ,  0 ,  0 ,  0 ,  1 ,  75 ,  5 ,  0 ,  0 ,  75 ,  5 ,  1 ,  14 ,  0 ,  1 ,  0 ,  0 ,  0 ,  0 ,  101 ,  5 ,  0 ,  0 ,  81 ,  5 ,  0 ,  0 ,  112 ,  5 ,  0 ,  0 ,  0 ,  1 ,  0 ,  32};
    
    
    if(g_ui32StartAddress != 0xffffffff)
    {
        //
        // Send the run command but just send the packet, there will likely
        // be no boot loader to answer after this command completes.
        //
        g_pui8Buffer[0] = COMMAND_RUN;
        g_pui8Buffer[1] = (uint8_t)(g_ui32StartAddress>>24);
        g_pui8Buffer[2] = (uint8_t)(g_ui32StartAddress>>16);
        g_pui8Buffer[3] = (uint8_t)(g_ui32StartAddress>>8);
        g_pui8Buffer[4] = (uint8_t)g_ui32StartAddress;
        if(SendPacket(g_pui8Buffer, 5, 0) < 0)
        {
            pc.printf("Failed to Send Run command\n");
        }
        else
        {
            pc.printf("Running from address %08x\n",g_ui32StartAddress);
        }
        
    }
    
    else
    {
    
        g_pui8Buffer[0] = COMMAND_DOWNLOAD;
        g_pui8Buffer[1] = (uint8_t)(g_ui32DownloadAddress >> 24);
        g_pui8Buffer[2] = (uint8_t)(g_ui32DownloadAddress >> 16);
        g_pui8Buffer[3] = (uint8_t)(g_ui32DownloadAddress >> 8);
        g_pui8Buffer[4] = (uint8_t)g_ui32DownloadAddress;
        g_pui8Buffer[5] = (uint8_t)(ui32TransferLength>>24);
        g_pui8Buffer[6] = (uint8_t)(ui32TransferLength>>16);
        g_pui8Buffer[7] = (uint8_t)(ui32TransferLength>>8);
        g_pui8Buffer[8] = (uint8_t)ui32TransferLength;
    }
    
    
    ui8Command = COMMAND_PING;
    if(SendCommand(&ui8Command, 1) < 0)
    {
        pc.printf("Ping fail");
        return(-1);
    }
    
    if(SendCommand(g_pui8Buffer, 9) < 0)
    {
        pc.printf("Failed to Send Download Command\n");
        return(-1);
    }
    
    
ui32Offset = 0;

    pc.printf("Remaining Bytes: ");
    do
    {
        uint8_t ui8BytesSent;

        g_pui8Buffer[0] = COMMAND_SEND_DATA;

        pc.printf("%08ld", ui32TransferLength);

        //
        // Send out 8 bytes at a time to throttle download rate and avoid
        // overruning the device since it is programming flash on the fly.
        //
        if(ui32TransferLength >= g_ui32DataSize)
        {
            memcpy(&g_pui8Buffer[1], &pui8FileBuffer[ui32Offset], g_ui32DataSize);

            ui32Offset += g_ui32DataSize;
            ui32TransferLength -= g_ui32DataSize;
            ui8BytesSent = g_ui32DataSize + 1;
        }
        else
        {
            memcpy(&g_pui8Buffer[1], &pui8FileBuffer[ui32Offset], ui32TransferLength);
            ui32Offset += ui32TransferLength;
            ui8BytesSent = ui32TransferLength + 1;
            ui32TransferLength = 0;
        }
        //
        // Send the Send Data command to the device.
        //
        if(SendCommand(g_pui8Buffer, ui8BytesSent) < 0)
        {
            pc.printf("Failed to Send Packet data\n");
            break;
        }

        pc.printf("\b\b\b\b\b\b\b\b");
    } while (ui32TransferLength);
    pc.printf("00000000\n");
    
    g_pui8Buffer[0] = COMMAND_RESET;
    SendPacket(g_pui8Buffer, 1, 0);

}