#include "mbed.h"
#define ENDL "\r" << endl;
#define START_ADDRESS 0x020;
#define PI 3.14

InterruptIn SPI_INT(PTD2);
SPI adf(PTD6,PTD7,PTD5 );
DigitalOut CS(PTD4);
Serial pc(USBTX, USBRX);
DigitalOut flash(LED4);


int src=0;
int irqsrc = 0;
int j = 0;
int k = 0;
int x=0;
int irq1=0;
unsigned char data[]={0x65,0xD3,0x06,0x08,0xBB,0xE7,0xCD,0x16,0x65,0xD3,0x06,0x08,0xBB,0xE7,0xCD,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x20,0xE5,0xEE,0x00,0xCE,0x56,0x33,0x76,0x2D,0xD7,0x5F,0x0A,0x2D,0xD5,0x9D,0x36,0xD2,0x2C,0x97,0xB2,0xF1,0xA8,0xBE,0xE4,0x9F,0xE8,0x57,0x8C,0x01,0x27,0xB2,0x34,0x6B,0x5E,0x9A,0x30,0x5F,0x78,0x7C,0x0E,0xDC,0x0D,0x4B,0x78,0x00,0x13,0x09,0xDA,0xAD,0x9A,0x3C,0xD6,0xCC,0xB2,0x89,0x8C,0xB4,0xA0,0x0B,0xA4,0x14,0x09,0xEE,0x9C,0x62,0x86,0x53,0xBE,0x59,0x56,0xF7,0xF2,0x71,0x75,0x04,0xE4,0xC7,0x7B,0xBA,0xAC,0xE6,0x0A,0xB9,0x74,0x2B,0x87,0x2D,0x82,0x3D,0x3D,0xCF,0x44,0x48,0xAE,0xA2,0xB2,0xD8,0x88,0xEA,0x68,0x69,0x50,0x0C,0xFA,0xB9,0x3F,0xF9,0xAE,0x2D,0xA6,0x70,0x76,0x99,0xBA,0x99,0xF8,0x61,0xA9,0xBA,0xF6,0x62,0xC9,0xFB,0x74,0xB2,0x4A,0xFF,0xD0,0x1B,0xA2,0x61,0x30,0x08,0xB0,0x51,0x38,0x2D,0x33,0x95,0x8E,0xB7,0x6B,0x75,0xD4,0xF0,0xAB,0x75,0x66,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x20,0xE5,0xEE,0x00,0x53,0x54,0x8B,0x26,0xFB,0x1C,0x6A,0x2E,0x6E,0x67,0xFA,0x14,0x78,0xC0,0x49,0xEC,0x23,0x5A,0xD7,0xA4,0xA3,0x17,0xDE,0x1E,0x40,0xD7,0x03,0x52,0x37,0x80,0x04,0xC2,0x1D,0x8B,0x66,0x8E,0x4D,0x53,0x2C,0xA2,0x18,0xED,0x28,0x00,0xBA,0x45,0x02,0x7A,0x69,0xD8,0xA1,0x94,0x3B,0xF6,0x55,0xBC,0x7F,0x3C,0x5D,0x42,0xCE,0x71,0xDE,0xEC,0xAA,0xF9,0x82,0xAC,0x97,0x4A,0xE1,0xCA,0x58,0x2F,0x4F,0x70,0xF4,0x52,0x2B,0xAA,0xAB,0x16,0x22,0x3A,0x26,0x9A,0x54,0x00,0xCF,0x8E,0x4F,0xFE,0x1A,0xEB,0x69,0x9E,0x87,0x46,0x6E,0xA6,0x1F,0x98,0x6A,0x6C,0xAF,0x78,0xB2,0x7E,0x37,0x6C,0x92,0xBE,0x7D,0x06,0xE8,0x9A,0x93,0x02,0x2C,0x14,0x13,0x8B,0x4C,0xE4,0x58,0xCD,0xDA,0xDC,0x5D,0x7C,0x2A,0xDC,0x56,0x74,0xD5,0x20,0xB2,0x5E,0xC7,0x18,0xA2,0xFB,0x99,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x97,0x4C,0x18,0x22,0xEF,0x9F,0x34,0x59,0x97,0x4C,0x18,0x22,0xEF,0x9F,0x34,0x58,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x97,0x4C,0x18,0x22,0xEF,0x9F,0x34,0x59,0x97,0x4C,0x18,0x22,0xEF,0x9F,0x34,0x58,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

void ISR (void)
{
    
    flash = !flash;
       
        CS=0;
    adf.write(0x0B);//IRQ_SOURCE_Random write //To read CMD = 2B 36 FF FF
    adf.write(0x36);//Address : 0x336
    adf.write(0xFF);//Put Low
    CS=1;

    CS=0;


    CS=0;
    k=0;

    if(!j){
        adf.write(0x18);
        adf.write(0x20);
        while(k<=223){

          adf.write(data[k]);
          k++;
            }

         }

    else if(j<=sizeof(data)/112){

                if(j%2){  //src==  Buffer Half Full src == 1
                adf.write(0x18);
                adf.write(0x20);
                }


            else{               //src==   Buffer is Full src==2
                adf.write(0x18);
                adf.write(0x90);
                }


            while(k<=111){
                adf.write(data[(j+1)*112+k]);
                k++;

            }
     }
     j++;
     if(j>=(sizeof(data)/112) )
     j=1;
     CS=1;
     wait_us(5);    

    
 
    
}

void initiate(void){

    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
    wait_ms(2);

    CS=0;
    adf.write(0x08);    // TRANSMIT_DATA LENGTH
    adf.write(0x14);
    adf.write(0xFF);
    CS=1;
    wait_ms(2);

    CS=0;
    adf.write(0x08);        // TRANSMIT_DATA LENGTH
    adf.write(0x15);
    adf.write(0xFF);
    CS=1;
    wait_ms(2);

    CS=0;
    adf.write(0x09);
    adf.write(0x24);   // TX_BASE ADDRESS   0x20(starting Tx Byte)
    adf.write(0x20);
    CS=1;
    wait_ms(2);

    CS=0;
    adf.write(0x09);
    adf.write(0x37);// BUFFER SIZE 0xE0=224 Bytes 0x137 is adress of buffer size
    adf.write(0xE0);
    CS=1;
    wait_ms(2);

    CS=0;
    adf.write(0x09);
    adf.write(0x36);//BB_Tx_Buffer Signal when Buffer is half filled
    adf.write(0x70);//0x70 = 112 >> When Half buffer interrupt is given
    CS=1;
    wait_ms(2);


    CS=0;
    adf.write(0x09);
    adf.write(0x39);//BB_Tx_Buffer Signal when Buffer is half filled
    adf.write(0x10);//0x70 = 112 >> When Half buffer interrupt is given
    CS=1;
    wait_ms(2);



    }
    
void bbram_write()
{
    CS=0;
    adf.write(0xB0);//PHY_OFF
    wait_ms(2);
    CS=1;

    // Write bbram
    CS=0;
    adf.write(0x19);
    adf.write(0x00);
    adf.write(0x60);
    adf.write(0x00);

    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);

    adf.write(0x00);
    adf.write(0x33);
    adf.write(0x00);
    adf.write(0xF4);//Frequency Register F9 = 435.802 MHz F4 = 435.800 MHz

    adf.write(0xC2);
    adf.write(0x10);
    adf.write(0xC0);
    adf.write(0x00);

    adf.write(0x30);
    adf.write(0x31);
    adf.write(0x07);
    adf.write(0x00);

    adf.write(0x01);
    adf.write(0x00);
    adf.write(0x7F);
    adf.write(0x00);

    adf.write(0x0B);
    adf.write(0x37);
    adf.write(0x00);
    adf.write(0x00);

    adf.write(0x40);
    adf.write(0x0C);
    adf.write(0x00);
    adf.write(0x05);

    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x18);
    adf.write(0x12);

    adf.write(0x34);
    adf.write(0x56);
    adf.write(0x10);
    adf.write(0x10);

    adf.write(0xC4); // Different
    adf.write(0x14);
    adf.write(0x00);
    adf.write(0x00);

    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);

    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);

    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);

    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);

    adf.write(0x04);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);

    adf.write(0x00);
    adf.write(0x00);
    CS=1;
    wait(1);

}

void send_data(void){

    CS=0;
    adf.write(0xBB);
    CS=1;
    wait_ms(2);

    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
    wait_ms(2);

   // write_data();
    ISR();

    CS=0;
    adf.write(0xB1);
    CS=1;
    wait_ms(2);

    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
    wait_ms(2);

    CS=0;
    adf.write(0xB5);
    CS=1;
    wait_ms(2);

    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
    wait_us(20);

}


int main (void)
{
    
    CS = 1;
    adf.format(8,0);
    adf.frequency(1000000);
    SPI_INT.rise(&ISR);
    bbram_write();
    initiate();
    send_data();
    while(1);

    
}

