// TESTING PUSH PULL IN MAIN CPP

#include "mbed.h"

#define DEBUG 1

#include "SimpleDMA.h"
#include "dmaSPIslave.h"
#include "rtos.h"
#include "mbed_debug.h"

#include "Structures.h"
#include "pinconfig.h"
#include "DefinitionsAndGlobals.h"
#include "crc.h"
#include "i2c.h"
#include "COM_SND_TM_functions.h"
#include "COM_SND_TM.h"
#include "cdms_sd.h"
#include "common_functions.h"
//#include "CDMS_HK.h"
#include "OBSRS.h"
#include "adf.h"
#include "COM_RCV_TC.h"
#include "COM_MNG_TMTC.h"
#include "COM_POWER_ON_TX.h"
#include "COM_POWER_OFF_TX.h"
#include "Compression.h"
#include "ThreadsAndFunctions.h"

//void set_sig(){gSCIENCE_THREAD->signal_set(SCIENCE_SIGNAL);}
int main()
{
    //gLEDR = 1;
    
    // ******************INITIALISATIONS START******************
    // COM RX
    RX1M.baud(1200);
    gRX_HEAD_DATA_NODE = new COM_RX_DATA_NODE;
    gRX_HEAD_DATA_NODE->next_node = NULL;
    gRX_CURRENT_DATA_NODE = gRX_HEAD_DATA_NODE;
    gRX_COUNT = 0;
//    gRX_CURRENT_PTR = gRX_CURRENT_DATA_NODE->values;
    RX1M.attach(&rx_read, Serial::RxIrq);
    
    gPC.baud(1200);
    
    // COMMON SPI
    spi.format(8,0);
    spi.frequency(1000000);

    // SD CARD
    cs_sd = 1;
    gCS_RTC = 1;
    gCS_ADF = 1;
    
    FCTN_CDMS_INIT_RTC();/* rtc initialization*/
    FCTN_CDMS_SD_INIT();/* sd card initialization*/
    
    if (DEBUG)
        gPC.puts("welcome to mng_tmtc\r\n");
        
    // COM_MNG_TMTC THREAD
    gCOM_MNG_TMTC_THREAD = new Thread(COM_MNG_TMTC_FUN);
    gCOM_MNG_TMTC_THREAD->set_priority(osPriorityAboveNormal);
    if (DEBUG)
        gPC.puts("allocating threads\r\n");
    gSCIENCE_THREAD = new Thread(SCIENCE_FUN);
   // gPC.puts("step one complete\r\n");
    gSCIENCE_THREAD->set_priority(osPriorityBelowNormal);
    if (DEBUG)
        gPC.puts("competed allocating threads\r\n");
        
    // *******************INITIALISATIONS END********************
    
    //RtosTimer gCDMS_HK_TIMER(FCTN_CDMS_HK_MAIN, osTimerPeriodic);
    //gCDMS_HK_TIMER.start(5000);
    
    /*starting the thread with signal*/
//    set_sig();
    
    /*Calculating Stack used*/
    
    int state;
    /*while (true) { 
    Thread::wait(500); 
    state = gSCIENCE_THREAD->get_state(); 
    //gPC.printf("Thread state %d\r\n", state); 
    if(state == Thread::Inactive) 
    {delete gSCIENCE_THREAD;
    break;}
    }*/
    
    
    
    while(true){
        Thread::wait(osWaitForever);
        //state = gCOM_MNG_TMTC_THREAD->get_state() + '0';
         gLEDG = !gLEDG;
        //gPC.putc(state); 
    }
}