#include "mbed.h"
#include "FATFileSystem.h"
#include "SDBlockDeviceDISCOF746NG.h"
#include <stdio.h>
#include <errno.h>
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"
#include <string>
#include <fstream> //library für file streams
//#include <iostream> //für input/output von streams
LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
TS_StateTypeDef TS_State;
I2C i2c(I2C_SDA, I2C_SCL );
SDBlockDeviceDISCOF746NG bd;
FATFileSystem fs ("fs");
uint32_t linecheck(uint8_t Channel); //Function to Check a wire connection 
uint8_t channel;
uint8_t g=0,lc=0,gmax=0;
uint8_t channel_max =32;
char channel_result[32]; //Array for test-result
string Result = "NOK";
uint8_t mode=0,quad=0,cp=0,bc=0; //Modus of program (1:1==1, Load from SDCard==2, Learn==3)
uint8_t escrep=0;//escape=1 or repeat=2 same mode?
uint8_t trippelchoose (uint8_t mode);
uint8_t quadchoose (uint8_t quad);
uint8_t readCabletext();
uint16_t x, y,temp_count;
uint32_t rv,cv; //32Bitvariable rv=resultvector cv=channelvector
uint8_t idx;
uint8_t prev_nb_touches = 0;
uint8_t cleared = 0;
string ws,sz,ls;
//#################
struct Cable  {
    string internal_name; // Kabelname und Bezeichnung ggf. interne Nummer
    string navision_number;
    char wiring_in[32];
    char wiring_out[32];
} CableIndex [127];


void
return_error (int ret_val)
{
    if(ret_val)
        printf ("Failure. %d\r\n", ret_val);
    else
        printf ("done.\r\n");
}

void
errno_error (void* ret_val)
{
    if(ret_val == NULL)
        printf (" Failure. %d \r\n", errno);
    else
        printf (" done.\r\n");
}

int main()
{

    Serial pc (SERIAL_TX, SERIAL_RX);
    pc.baud(115200);
//################ INIT I2C devices
const int I2C_ChOut  = 0x20<<1; //  I2C address for input devices
     char cmd [2]; //Variable for commandstring (send / read )input

    for(int i=0;i<4;i++) { //set all I2C output to LOW 
    cmd[0] = 0x03;//configuration-register I2C device
    cmd[1] = 0x00;//sets this device for output
    i2c.write(I2C_ChOut+2*i, cmd, 2);//send 2 configbyte to I2C device
    cmd[0] = 0x01;// I2C device for output
    cmd[1] = 0x00;//bitpattern == 8bit LOW
    i2c.write(I2C_ChOut+2*i, cmd, 2);//Send bitpattern for output
    }

//################ Init Touchsreen and LCD
    TS_StateTypeDef TS_State;
    char text[30];
    uint8_t status;
    uint8_t idx;
    //uint32_t PURPLE=0xffC800C8; //Colorcode
    uint32_t DBLUE=0xff000064; //Colorcode
    uint8_t channel_idx;
    //uint8_t escrep;//escape=1 or repeat=2 same mode?

    lcd.SetFont(&Font20);
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }
    lcd.Clear(DBLUE);
    lcd.SetBackColor(DBLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetFont(&Font24);
    sprintf((char*)text, "Advanced Cable Tester");
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)&text, CENTER_MODE);
    lcd.SetBackColor(DBLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetFont(&Font20);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Reading cabledata from sd-card...", CENTER_MODE);

    printf("Start\n");
    int error = 0;
    return_error(error);

    printf("Mounting the filesystem on \"/fs\". ");
    error = fs.mount(&bd);
    return_error(error);
    gmax=readCabletext();
    sprintf((char*)text, "Read %d cables from file", gmax);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)&text, CENTER_MODE);
    printf("Read %d cables from file \r\n", gmax); //
    wait(2);
    do {
        mode=0;

        lcd.Clear(DBLUE);
        lcd.SetBackColor(DBLUE);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.SetFont(&Font24);
        sprintf((char*)text, "Advanced Cable Tester");
        lcd.DisplayStringAt(0, LINE(2), (uint8_t *)&text, CENTER_MODE);
        sprintf((char*)text, "choose Mode");
        lcd.DisplayStringAt(0, LINE(3), (uint8_t *)&text, CENTER_MODE);
        lcd.SetFont(&Font16);
        // lcd.DisplayStringAt(0, LINE(10), (uint8_t *)"IPG", CENTER_MODE);

        while(mode==0) {

            mode=trippelchoose (mode);
            //printf("Modus=%d \r\n",mode);
        }
        switch(mode) {
            case 1: {
                // Check of 1:1 Cable here (32 Positions)
                lcd.DisplayStringAt(20, LINE(1), (uint8_t *)&text, LEFT_MODE);
                lcd.Clear(DBLUE);
                lcd.SetBackColor(DBLUE);
                lcd.SetFont(&Font16);
                lcd.SetTextColor(LCD_COLOR_WHITE);
                sprintf((char*)text, "+++++++++ 1:1 Test running +++++++++");
                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, CENTER_MODE);
                lcd.SetTextColor(LCD_COLOR_RED);
                lcd.FillRect(200, 15, 50, 250);
                //lcd.Clear(LCD_COLOR_BLUE);
                lcd.SetBackColor(LCD_COLOR_RED);
                lcd.SetTextColor(LCD_COLOR_WHITE);
                lcd.SetFont(&Font24);
                sprintf((char*)text, "E");
                lcd.DisplayStringAt(216, LINE(3), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "S");
                lcd.DisplayStringAt(216, LINE(4), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "C");
                lcd.DisplayStringAt(216, LINE(5), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "A");
                lcd.DisplayStringAt(216, LINE(6), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "P");
                lcd.DisplayStringAt(216, LINE(7), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "E");
                lcd.DisplayStringAt(216, LINE(8), (uint8_t *)&text, LEFT_MODE);
                lcd.SetFont(&Font16);
                lcd.SetBackColor(DBLUE);
                while(mode==1) {
                     for (channel_idx = 0 ; channel_idx < channel_max/2; channel_idx++) {
                        rv=linecheck(channel_idx); //Line check (#)
                        cv=1<<channel_idx; 
                        printf ("Index%d CV:%d RV:%d \r\n",channel_idx,cv,rv);
                        if (channel_idx <16) {
                            if(rv==cv) {
                                lcd.SetTextColor(LCD_COLOR_GREEN);
                                Result = "Okay";
                            } else {
                                lcd.SetTextColor(LCD_COLOR_RED);
                                Result = "Error";
                            }
                            sprintf(text,"Line(%d)=%s",channel_idx+1,"     ");
                            lcd.DisplayStringAt(35, LINE(channel_idx+1), (uint8_t *)&text, LEFT_MODE);
                            wait(.005);
                            sprintf(text,"Line(%d)=%s",channel_idx+1,Result.c_str());
                            lcd.DisplayStringAt(35, LINE(channel_idx+1), (uint8_t *)&text, LEFT_MODE);
                        }
                        rv=linecheck(channel_idx+16); //Line check (#)
                        cv=1<<channel_idx+16; 
                        if (channel_idx+16 >15) {
                             if(rv==cv)  {
                                lcd.SetTextColor(LCD_COLOR_GREEN);
                                Result = "Okay";
                            } else {
                                lcd.SetTextColor(LCD_COLOR_RED);
                                Result = "Error";
                            }
                            sprintf((char*)text,"Line(%d)=%s",channel_idx+16+1,"     ");
                            lcd.DisplayStringAt(260, LINE(channel_idx+16-16+1), (uint8_t *)&text, LEFT_MODE);
                            wait(.005);
                            sprintf((char*)text,"Line(%d)=%s",channel_idx+16+1,Result.c_str());
                            lcd.DisplayStringAt(260, LINE(channel_idx+16-16+1), (uint8_t *)&text, LEFT_MODE);
                        }
                        ts.ResetTouchData(&TS_State);
                        ts.GetState(&TS_State);
                        if (TS_State.touchDetected) {
                            x = TS_State.touchX[idx];
                            y = TS_State.touchY[idx];
                            if (y>15 and y<275) {
                                if (x>200 and x<250)   {
                                    printf("Stop running 1:1 checking");
                                    mode=0;
                                    break;
                                }
                            }
                        }
                    }
                    wait (.1);
                }
            }
            case 2: {
                while(mode==2) {
                    lcd.Clear(DBLUE);
                    lcd.SetBackColor(DBLUE);
                    lcd.SetFont(&Font16);
                    lcd.SetTextColor(LCD_COLOR_WHITE);
                    sprintf((char*)text, "++++++++++++ Choose Cable ++++++++++++");
                    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, CENTER_MODE);
                    //printf("gmax= %d, g= %d CP=%d \r\n",gmax,g,g+10*bc);
                    cp=1; //Cablepointer inside this codeblock (--> point actuell index onto cabledata )
                    bc=0; //blockcounter (usage for second decimal value 10th)
                    for (g=0; g<10; g++) {
                        //.substr(0, myString.size()-2);
                        //sprintf((char*)text,"(%d) %s\n",g+1,CableIndex[g].internal_name.c_str());
                        sprintf((char*)text,"(%d) %s", g+1,CableIndex[g].internal_name.substr(0, CableIndex[g].internal_name.size()-1).c_str());
                        lcd.DisplayStringAt(25, LINE(g+1), (uint8_t *)&text, LEFT_MODE);
                        lcd.SetTextColor(LCD_COLOR_GREEN);
                        lcd.DisplayStringAt(5, LINE(cp), (uint8_t *)"=>", LEFT_MODE);
                        lcd.SetTextColor(LCD_COLOR_WHITE);
                    }
                    do {
                        quad=quadchoose (quad);
                        //printf("Quad=%c ",quad);
                        if (quad=='>') {
                            for(int n=1; n<11; n++) {
                                lcd.DisplayStringAt(5, LINE(n), (uint8_t *)"  ", LEFT_MODE);
                            } //Clear of old ">" indicator
                            cp++;
                            if (cp==11) {
                                if (gmax > cp+10*bc) {
                                    bc++;
                                    cp=1;
                                } else {
                                    cp=10;
                                }
                                lcd.Clear(DBLUE);
                                lcd.SetBackColor(DBLUE);
                                sprintf((char*)text, "++++++++++++ Choose Cable ++++++++++++");
                                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, CENTER_MODE);
                                for (g=0; g<10; g++) {
                                    //sprintf((char*)text,"(%d) %s",(bc*10+g+1),CableIndex[(bc*10)+g].internal_name.c_str());
                                    sprintf((char*)text,"(%d) %s", (bc*10+g+1),CableIndex[(bc*10)+g].internal_name.substr(0, CableIndex[(bc*10)+g].internal_name.size()-1).c_str());
                                    lcd.DisplayStringAt(25, LINE(g+1), (uint8_t *)&text, LEFT_MODE);
                                    printf("(%d) %s",(bc*10+g+1),CableIndex[(bc*10)+g].internal_name.c_str());
                                }
                            }
                            lcd.SetTextColor(LCD_COLOR_GREEN);
                            lcd.DisplayStringAt(5, LINE(cp), (uint8_t *)"=>", LEFT_MODE);
                            lcd.SetTextColor(LCD_COLOR_WHITE);
                        }
                        if (quad=='<') {
                            for(int n=1; n<11; n++) {
                             
                                lcd.DisplayStringAt(5, LINE(n), (uint8_t *)"  ", LEFT_MODE);
                            } //Clear of old ">" indicator
                            cp--;
                              printf("cp=%d\r\n",cp);
                            if (cp==0) {
                                if(bc>0) {
                                    bc--;
                                    cp=10;
                                } else {
                                    cp=1;
                                }
                                lcd.Clear(DBLUE);
                                lcd.SetBackColor(DBLUE);
                                sprintf((char*)text, "++++++++++++ Choose Cable ++++++++++++");
                                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, CENTER_MODE);
                                for (g=0; g<10; g++) {
                                    printf("g=%d, bc=%d \r\n",g,bc);
                                    //sprintf((char*)text,"(%d) %s",(bc*10+g+1),CableIndex[bc*10+g].internal_name.c_str());
                                    sprintf((char*)text,"(%d) %s", (bc*10+g+1),CableIndex[(bc*10)+g].internal_name.substr(0, CableIndex[(bc*10)+g].internal_name.size()-1).c_str());
                                    lcd.DisplayStringAt(25, LINE(g+1), (uint8_t *)&text, LEFT_MODE);
                                }
                            }
                            lcd.SetFont(&Font16);
                            lcd.SetTextColor(LCD_COLOR_GREEN);
                            lcd.DisplayStringAt(5, LINE(cp), (uint8_t *)"=>", LEFT_MODE);
                            lcd.SetTextColor(LCD_COLOR_WHITE);
                        }


                        if (quad==13) {
                            printf("ENTER DETECTED");
                            mode=0;
                            
                            //Testfunktion aufrufen
                            //break;
                        }
                        if (quad==27) {
                            printf("Escape DETECTED");
                            mode=0;
                            break;
                        }

                        printf("CableIndex=%d \r\n",cp+10*bc);
                        printf("---->Quad=%d \r\n",quad);

                        wait(.1);
                    } while ((quad!=0x13)or(quad!=0x1b));
                }

                break;
                //escrep=1;
            }
            default : 
                printf("Switch/Case default code here");
                break;
        }


        /*wait(1);
        lcd.SetFont(&Font20);
        lcd.SetBackColor(DBLUE);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        sprintf((char*)text,"ENDE ? Advanced Cable Tester" );
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
        while(1) {
            lcd.SetFont(&Font24);
            sprintf((char*)text, "Advanced Cable Tester");
            lcd.DisplayStringAt(60, LINE(4), (uint8_t *)&text, LEFT_MODE);
            sprintf((char*)text, "(Touch to start test)");
            lcd.DisplayStringAt(60, LINE(6), (uint8_t *)&text, LEFT_MODE);
            lcd.SetFont(&Font16);
            ts.GetState(&TS_State);
            if (TS_State.touchDetected) {
                // Clear lines corresponding to old touches coordinates
                if (TS_State.touchDetected < prev_nb_touches) {
                    for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                        lcd.ClearStringLine(idx);
                    }
                }
                prev_nb_touches = TS_State.touchDetected;
                cleared = 0;
                lcd.SetBackColor(DBLUE);
                lcd.SetTextColor(LCD_COLOR_WHITE);
                wait(1);
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
            } else {
                if (!cleared) {
                    lcd.Clear(DBLUE);
                    //sprintf((char*)text, "Touches: 0");
                    //lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
                    cleared = 1;
                }
            }
        }
        */
    } while (1);
}

uint32_t linecheck(uint8_t channel)
{
    //####################################################################
    //Strategy: set only ONE bit ON of 32 channels and read all 32channel input
    //Save result in Array
    //then repeat that for next bit
    const int I2C_ChOut  = 0x20<<1; //  I2C address for input devices
    const int I2C_ChIn = 0x24<<1; //  I2C address for output devices
    char channel_set [8] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
    char cmd [2]; //Variable for commandstring (send / read )input

    char channel_result[4]; //Array for test-result
    uint8_t  ChOffset=0;
    //uint8_t text[30];
    uint8_t channel_idx;
    //uint8_t channel_result=0;
   
    channel_idx = channel;//-1;
    //wait (.005);
    ChOffset = abs(channel_idx/8);
    cmd[0] = 0x03;//configuration-register I2C device
    cmd[1] = 0x00;//sets this device for output
    i2c.write(I2C_ChOut+2*ChOffset, cmd, 2);//send 2 configbyte to I2C device
    cmd[0] = 0x01;// I2C device for output
    //cmd[1] = 0xFF & (channel_set[channel_idx%8]); //set bit for channel
    cmd[1] = channel_set[channel_idx%8];//bitpattern
    i2c.write(I2C_ChOut+2*ChOffset, cmd, 2);//Send bitpattern for output
    //wait(0.001);// on for 5ms !!!!!!!!!!! modified
    /////cmd[0] = 0x03;//configurationregister I2C device 
    /////cmd[1] = 0xFF;//set this 8Bit device for Input
    /////i2c.write(I2C_ChIn, cmd, 2);//send 2 configbyte to I2C device 
    cmd[0] = 0x00;
    i2c.write(I2C_ChIn+0, cmd, 1);
    i2c.read(I2C_ChIn+0, cmd, 1);
    channel_result[0]=cmd[0];
    //printf ("R=%d ch=%d \r\n", cmd[0],channel_idx);
    cmd[0] = 0x00;
    i2c.write(I2C_ChIn+2, cmd, 1);
    i2c.read(I2C_ChIn+2, cmd, 1);
    channel_result[1]=cmd[0];
    //printf ("R=%d ch=%d \r\n", cmd[0],channel_idx);
    cmd[0] = 0x00;
    i2c.write(I2C_ChIn+4, cmd, 1);
    i2c.read(I2C_ChIn+4, cmd, 1);
    channel_result[2]=cmd[0];
    //printf ("R=%d ch=%d \r\n", cmd[0],channel_idx);
    cmd[0] = 0x00;
    i2c.write(I2C_ChIn+6, cmd, 1);
    i2c.read(I2C_ChIn+6, cmd, 1);
    channel_result[3]=cmd[0];
    printf ("Ch:%d R%d %d %d %d \r\n",channel_idx,channel_result[0],channel_result[1],channel_result[2],channel_result[3]);
    /////////------ read
    /*cmd[0] = 0x03;//configurationregister I2C device 
    cmd[1] = 0xFF;//sets 8bit of this device for intput
    i2c.write(I2C_ChIn+2*0, cmd, 2);//send config I2C device for output
    cmd[0]= 0x0;
    i2c.write(I2C_ChIn+2*0, cmd, 1);// prepare to read 
    i2c.read(I2C_ChIn+2*0, cmd, 1);
    printf ("R=%d ch=%d \r\n", cmd[0],channel_idx);*/
    //channel_result=cmd[0];
    ////////
    
    cmd[0] = 0x03;
    cmd[1] = 0x00;//config to out
    i2c.write(I2C_ChOut+2*ChOffset, cmd, 2);
    cmd[0] = 0x01;
    cmd[1] = 0x00; //bitpattern
    i2c.write(I2C_ChOut+2*ChOffset, cmd, 2);
    //wait (.001);
    rv=256*256*256*channel_result[3]+256*256*channel_result[2]+256*channel_result[1]+channel_result[0];
    printf ("RV: %d \r\n",rv);
    return rv; // 32Bit in 4 Byte
}

uint8_t trippelchoose (uint8_t mode)
{

    lcd.DrawRect(13, 185, 135, 40);
    lcd.DisplayStringAt(25, LINE(12), (uint8_t *)"1:1 Cable", LEFT_MODE);

    lcd.DrawRect(173, 185, 135, 40);
    lcd.DisplayStringAt(180, LINE(12), (uint8_t *)"Choose from", LEFT_MODE);
    lcd.DisplayStringAt(180, LINE(13), (uint8_t *)"  SD-Card", LEFT_MODE);

    lcd.DrawRect(333, 185, 135, 40);
    lcd.DisplayStringAt(340, LINE(12), (uint8_t *)"Learn new", LEFT_MODE);
    wait(.1);
    //printf("#####\r\n");
    ts.ResetTouchData(&TS_State);
    ts.GetState(&TS_State);
    if (TS_State.touchDetected) {
        x = TS_State.touchX[idx];
        y = TS_State.touchY[idx];

        if (y>185 and y<185+40) {
            if (x>13 and x<135+13)   {
                mode=1;
            }
            if (x>173 and x<173+135) {
                mode=2;
            }
            if (x>333 and x<333+135) {
                mode=3;
            }
        }
        printf("X=%d Y=%d Modus=%d \r\n",TS_State.touchX[idx],y,mode);
        //prev_nb_touches = TS_State.touchDetected;
        //cleared = 0;
    }

    return mode;
}
uint8_t readCabletext()
   {
   //Read and Parsing of intput file "cable.txt"  from SD-Card
     printf("Opening file read-only.");
//FILE* fd = fopen("/fs/numbers5.txt", "w");    
//FILE* fd = fopen("/fs/cable.txt", "r");
    
    std::ifstream fd("/fs/cable.txt"); //öffnet die Datei als c++ stream. fd = name der variable 
    std::string line; //variable für die aktuelle Zeile
        printf("geoeffnet ?\n");
    while(std::getline(fd, line)) { //solange die zeilen gelesen werden können
        printf("%s\n", line.c_str());   //gelesene zeile als c-string ausgeben
        //printf("inWhile ?\n");
    }
    //Der zweite Teil ist C++ aber mit ein bisschen C an einigen Stellen
    FILE* fd2 = fopen("/fs/cable.txt", "r"); //datei zum "lesen als textdatei" öffnen
    std::string line2;
      printf("geoeffnet ?\r\n");
      int lc=0;
    while(!feof(fd2)) {
        char buffer[1] = {0}; //buffer für das zu lesende byte
        int bytes_read = fread(&buffer, 1, sizeof(char), fd2); // 1 byte (zeichen) lesen
        if (*buffer != '\n') { //wenn buffer nicht '\n' (neue zeile) ist
            line2 = line2 + &buffer[0]; //string um aktuelles zeichen erweitern
        }
        if (*buffer == '\n') { //wenn neue zeile gefunden
            //printf("(%d) %s\n",lc%4, line2.c_str()); //zeile ausgeben
            switch(lc%4) {
                case 0:{
                    CableIndex[g].internal_name=line2.c_str();
                    printf("(g=%d)(lc=%d) Internal-Name= %s\r\n",g,lc, CableIndex[g].internal_name.c_str());
                    line2 = ""; //zeile löschen
                    lc++;
                    break;
                    }
                case 1:{
                    CableIndex[g].navision_number=line2.c_str();
                    printf("(g=%d) (lc=%d) Navision-Number= %s\r\n", g,lc,CableIndex[g].navision_number.c_str());
                    line2 = ""; //zeile löschen
                    lc++;
                    break;
                    }
         case 2:{
                    string hs=line2.c_str(); 
                    string::iterator zg;
                    uint8_t cf=0;
                        for (zg=hs.begin();zg<hs.end(); zg++) {                        
                               if ((*zg>47)&&(*zg<59)) {
                        CableIndex[g].wiring_in[cf] = (*(zg)-48)*10+(*(zg+1)-48);
                        zg=zg+2;
                        cf++;
                        }//end_if
                        }// end_for
                        line2 = ""; //zeile löschen
                        for (int ci = 0; ci < 32; ci++) //Fertige Zeile einmal ausgeben
                        {
                        printf("[%d]", CableIndex[g].wiring_in[ci]);
                        } //end_for
                        printf("\r\n");
                    line2 = ""; //zeile löschen
                    lc++;
                    break;
                      }
                case 3:{
                    string hs=line2.c_str(); 
                    string::iterator zg;
                    uint8_t cf=0;
                        for (zg=hs.begin();zg<hs.end(); zg++) {                        
                               if ((*zg>47)&&(*zg<59)) {
                        CableIndex[g].wiring_out[cf] = (*(zg)-48)*10+(*(zg+1)-48);
                        zg=zg+2;
                        cf++;
                        }//end_if
                        }// end_for
                        line2 = ""; //zeile löschen
                        for (int ci = 0; ci < 32; ci++) //Fertige Zeile einmal ausgeben
                        {
                        printf("(%d)", CableIndex[g].wiring_out[ci]);
                        } //end_for
                        printf("\r\n");
                    
                    line2 = ""; //zeile löschen
                    lc++;
                    break;
                      }
                
           
                   
            
            
        }
         
            line2 = ""; //zeile löschen
            
            if (lc==4) {
                lc=0;
                g++;}
    }   
        }
    fclose(fd2);//datei nach dem lesen schließen
    //return 0;
    
    //fd.close(); //datei nach lesen schließen
    //errno_error(fd);
        
    gmax=g;
    return gmax;
    
    }

uint8_t quadchoose (uint8_t quad)
{
    quad =0;
    lcd.SetFont(&Font24);
    lcd.DrawRect(15, 200, 90, 60);
    lcd.DisplayStringAt(45, LINE(9), (uint8_t *)"<", LEFT_MODE);

    lcd.DrawRect(135, 200, 90,60);
    lcd.DisplayStringAt(155, LINE(9), (uint8_t *)"ESC", LEFT_MODE);

    lcd.DrawRect(255, 200, 90, 60);
    lcd.DisplayStringAt(275, LINE(9), (uint8_t *)"ENT", LEFT_MODE);

    lcd.DrawRect(375, 200, 90, 60);
    lcd.DisplayStringAt(405, LINE(9), (uint8_t *)">", LEFT_MODE);

    lcd.SetFont(&Font16);
    do {
        ts.ResetTouchData(&TS_State);
        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            x = TS_State.touchX[idx];
            y = TS_State.touchY[idx];
            if (y>200 and y<200+60) {
                if (x>15 and x<15+90)   {
                    quad='<';//back
                }
                if (x>135 and x<135+90) {
                    quad=0x1b;//escape
                }
                if (x>255 and x<255+90) {
                    quad=0x0d;//enter
                }
                if (x>375 and x<375+90)   {
                    quad='>';//forward
                }
            }
        }
    }   while (quad==0);
    return quad;
}