/* Copyright (c) 2012 Otavio Netto Zani, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */



#include "oJSON.h"

//FUNCOES GENERICAS

int numberOfChars(char counter, string entrada){
    int n=0;
    string::iterator it;
    bool ignore=false;
    for(it=entrada.begin(); it<entrada.end();it++){
        if(*it == '{' || *it == '[')
            ignore = true;
        else if(*it == '}' || *it == ']')
            ignore = false;
        if(*it == counter && !ignore)
            n++;
    }
    return n;

}

string clear(string toDelete){
    string aux;
    string::iterator it;
    it=toDelete.begin();

    if(*it=='{' || *it=='['){
        aux=toDelete.substr(1,toDelete.size()-2);
        return aux;
    }
    return toDelete;


}


string* explode(char separator, string entrada){
    int n = numberOfChars(separator,clear(entrada));
    int aux=0, aux2=0;
    int i=0;
    string *retorno;
    string::iterator it;
    bool ignore = false;

    retorno = new string[n+1];

    if(n==0){
        retorno[0]=entrada;
        return retorno;
    }

    for(it = entrada.begin();it<entrada.end();it++){
        if(*it=='{' || *it=='[')
            ignore=true;
        else if(*it=='}' || *it==']')
            ignore=false;

        if(*it==separator && !ignore){
            if(aux2-aux>0)
                retorno[i] = entrada.substr(aux,aux2-aux);
            else
                retorno[i] = "";
            aux=aux2+1;
            i++;
        }

        if(it==entrada.end()-1)
            retorno[i]=entrada.substr(aux,aux2-aux+1);

        aux2++;
    }

    return retorno;

}

//FUNCOES DO OBJETO

JSONObject::JSONObject(char* interpreter){
    string convertida(interpreter);

    if(convertida.compare("{}")==0){
        nValues = 0;
        values=NULL;
        labels=NULL;
        return;
    }

    if(convertida.compare("null")==0)
        return;


    JSONObject::criar(convertida);
}


JSONObject::JSONObject(string entrada){
     if(entrada.compare("{}")==0){
        nValues = 0;
        values=NULL;
        labels=NULL;
        return;
    }

    if(entrada.compare("null")==0)
        return;

    criar(entrada);
}

JSONObject::JSONObject(){
    nValues=0;
    values=NULL;
    labels=NULL;

}


void JSONObject::criar(string entrada){
    string copyEntrada;
    string *aux, *aux2;

    copyEntrada = clear(entrada);
    nValues = numberOfChars(',',copyEntrada)+1;


    labels = new string[nValues];
    values = new string[nValues];
    

    aux2 = explode(',',copyEntrada);

    for(int i=0; i<nValues;i++){

        aux = explode(':', aux2[i]);

        labels[i]=aux[0];
        values[i]=aux[1];
    }

    return;
}


string JSONObject::getString(char* label){
    string label2(label);
    return getString(label2);
}

string JSONObject::getString(string label){

    for(int i=0; i<nValues; i++){
        if(label.compare(labels[i])==0){
            return values[i].substr(1,values[i].size()-2);

        }
    }
    return NULL;
}

JSONArray JSONObject::getArray(char* label){
    string label2(label);
    return getArray(label2);

}

JSONArray JSONObject::getArray(string label){

    for(int i=0; i<nValues; i++){
        if(label.compare(labels[i])==0){
            return (JSONArray) values[i];

        }
    }
    return NULL;
}

JSONObject JSONObject::getObject(char* label){
    string label2(label);
    return getObject(label2);

}

JSONObject JSONObject::getObject(string label){

    for(int i=0; i<nValues; i++){
        if(label.compare(labels[i])==0){
            return (JSONObject) values[i];

        }
    }
    return NULL;
}

float JSONObject::getFloat(char* label){
    string label2 (label);
    return getFloat(label2);
}

float JSONObject::getFloat(string label){
    float aux;
    char *aux2;

    for(int i=0; i<nValues; i++){
        if(label.compare(labels[i])==0){
            aux2=&values[i][0];
            sscanf(aux2,"%f",&aux);
            return aux;

        }
    }
    return NULL;


}

int JSONObject::getInt(char* label){
    string label2 (label);
    return getInt(label2);
}

int JSONObject::getInt(string label){
    int aux;
    char *aux2;

    for(int i=0; i<nValues; i++){
        if(label.compare(labels[i])==0){
            aux2=&values[i][0];
            sscanf(aux2,"%d",&aux);
            return aux;

        }
    }
    return NULL;


}

bool JSONObject::getBoolean(char *label){
    string label2(label);
    return getBoolean(label2);
}

bool JSONObject::getBoolean(string label){

     for(int i=0; i<nValues; i++){
        if(label.compare(labels[i])==0){
            if(values[i].compare("true")==0)
                return true;
            else if(values[i].compare("false")==0)
                return false;

        }
    }
    return NULL;

}

bool JSONObject::isNull(char *label){
    string label2(label);
    return isNull(label2);

}

bool JSONObject::isNull(string label){

    for(int i=0; i<nValues; i++){
        if(label.compare(labels[i])==0){
            if(values[i].compare("null")==0)
                return true;
            else
                return false;

        }
    }
    return NULL;



}

string JSONObject::toString(){
    string aux("{");

    for(int i=0; i<nValues; i++){
        aux+=labels[i]+":"+values[i];
        if(i==nValues-1)
            aux+="}";
        else
            aux+=",";

    }
    return aux;

}


void JSONObject::add(string label, JSONArray array){
    add(label,array.toString());
    return;
}

void JSONObject::add(string label, JSONObject object){
    add(label, object.toString());
    return;
}

void JSONObject::add(string label, bool boolean){
    string aux("");
    if(boolean){
        aux+="true";
        add(label, aux);
        return;
    }
    aux+="false";
    return;
}

void JSONObject::add(string label, int value){
    stringstream aux;
    aux<<value;
    add(label,aux.str());
    return;
}

void JSONObject::add(string label, float value){
    stringstream aux;
    aux<<value;
    add(label,aux.str());
    return;

}

void JSONObject::add(string label, string value){
    string *auxL, *auxV;
    auxL = new string[nValues+1];
    auxV = new string[nValues+1];
    for(int i=0; i<nValues;i++){
        auxL[i]=labels[i];
        auxV[i]=values[i];
    }
    nValues++;
    auxL[nValues-1]=label;
    auxV[nValues-1]=value;

    delete[] labels;
    delete[] values;

    labels=auxL;
    values=auxV;

    return;


}

// FUNCOES DA ARRAY

JSONArray::JSONArray(char *entrada){
    string convertida(entrada);
     if(convertida.compare("[]")==0){
        nValues = 0;
        values=NULL;
        return;
    }

    if(convertida.compare("null")==0)
        return;

    JSONArray::criar(convertida);
}

JSONArray::JSONArray(string entrada){

     if(entrada.compare("[]")==0){
        nValues = 0;
        values=NULL;
        return;
    }

    if(entrada.compare("null")==0)
        return;

    JSONArray::criar(entrada);
}

JSONArray::JSONArray(){
    nValues=0;
    values=NULL;
}

void JSONArray::criar(string entrada){
    string copyEntrada = clear(entrada);
    nValues = numberOfChars(',',copyEntrada)+1;

    values = explode(',',copyEntrada);


}


string JSONArray::getString(int index){
    return values[index].substr(1,values[index].size()-2);

}

JSONArray JSONArray::getArray(int index){
    return (JSONArray) values[index];
}

JSONObject JSONArray::getObject(int index){
    return (JSONObject) values[index];
}

int JSONArray::getInt(int index){
    int aux;
    char *aux2;

    aux2 = &values[index][0];

    sscanf(aux2, "%i",&aux);

    return aux;

}

float JSONArray::getFloat(int index){

    float aux;
    char *aux2;

    aux2 = &values[index][0];

    sscanf(aux2, "%f",&aux);

    return aux;

}

bool JSONArray::getBoolean(int index){
    if(values[index].compare("true")==0)
        return true;
    else if(values[index].compare("false")==0)
        return false;
    return NULL;
}

bool JSONArray::isNull(int index){
    if(values[index].compare("null")==0)
        return true;
    else
        return false;
        
}

string JSONArray::toString(){
    string aux("[");
    for(int i=0; i<nValues;i++){
        aux+=values[i];
        if(i==nValues-1)
            aux+="]";
        else
            aux+=",";

    }
    return aux;

}

void JSONArray::add(JSONArray array){
    add(array.toString());
    return;
}

void JSONArray::add(JSONObject object){
    add(object.toString());
    return;

}

void JSONArray::add(bool boolean){
    string aux("");
    if(boolean){
        aux+="true";
        add(aux);
        return;
    }
    aux+="false";
    add(aux);
    return;

}

void JSONArray::add(int value){
    stringstream aux;
    aux<<value;
    add(aux.str());
    return;
}

void JSONArray::add(float value){
    stringstream aux;
    aux<<value;
    add(aux.str());
    return;
}

void JSONArray::add(string value){

    string *auxV;
    auxV = new string[nValues+1];
    for(int i=0; i<nValues;i++){
        auxV[i]=values[i];
    }
    nValues++;
    auxV[nValues-1]=value;

    delete[] values;

    values=auxV;
    return;

}
