/* Copyright (c) 2012 Otavio Netto Zani, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */



#include "mbed.h"
#include <string>
#include <sstream>

//CLASSES

class JSONArray;

class JSONObject{

    int nValues;
    string* labels;
    string* values;

    public:

        JSONObject ();
        JSONObject (string);
        JSONObject (char*);

        int getInt (string);
        int getInt (char*);
        float getFloat (string);
        float getFloat (char*);
        string getString (string);
        string getString (char*);
        JSONArray getArray (string);
        JSONArray getArray (char*);
        JSONObject getObject (string);
        JSONObject getObject (char*);
        bool getBoolean(char*);
        bool getBoolean(string);
        bool isNull(char*);
        bool isNull(string);

        string toString();

        void add(string, string);
        void add(string, int);
        void add(string, float);
        void add(string, bool);
        void add(string, JSONObject);
        void add(string, JSONArray);

    private:
            void criar(string);

};

class JSONArray{

    int nValues;
    string *values;


    public:
        JSONArray ();
        JSONArray (string);
        JSONArray (char*);

        int getInt(int);
        float getFloat (int);
        string getString (int);
        JSONObject getObject (int);
        JSONArray getArray (int);
        bool getBoolean(int);
        bool isNull(int);

        string toString();

        void add(string);
        void add(int);
        void add(float);
        void add(bool);
        void add(JSONObject);
        void add(JSONArray);

    private:
        void criar(string);

};

int numberOfChars(char, string);
string clear(string);
string *explode(char, string);