#ifndef Task_h
#define Task_h

#include "mbed.h"

#define DEFAULT_INTERVAL 1000 //1ms

/**
 * Override this class to create a Task that can be managed with the TaskManager.
 */
class Task
{
    
public:

    /**
     * Contructor. Sets interval to default of 1ms.
     */
    Task();
    
    /**
     * Constructor.
     * @param _interval The running interval of the task in us.
     */
    Task(int _interval);
    
    /**
     * Starts the task. Should be automatically called from the TaskManager when it is added.
     */
    void start();
    
    /**
     * Virtual method which gets called at the specified interval.
     */
    virtual void tick() = 0;
    
    /**
     * Stops the task from running
     */
    void stop();
    
    /**
     * Returns true if the task is running.
     */
    bool isRunning() { return running; }
    

protected:

    /**
     * Set the interval that the task tick method runs.
     * @_interval Interval in us.
     */
    void setInterval(int _interval) { interval = _interval; }

    
private:

    Ticker ticker;
    int interval;
    bool running;
    
    void preTick();

};

#endif