#ifndef SerialLCD_h
#define SerialLCD_h

#include "mbed.h"

#define LCD_WIDTH 16
#define LCD_BAUD 9600

/**
 * SparkFun SerLCD v2.5 Controller
 */
class SerialLCD : public Serial
{
  public:
  
    /**
     * Constructor.
     * @param tx Connected to rx pin of LCD
     * @param rx Not connected but needs to be specified for serial interface.
     */
    SerialLCD(PinName tx, PinName rx);
    
    /**
     * Clear the LCD.
     */
    void clear();
    
    /**
     * Set backlight brightness;
     */
    void setBacklight(int brightness);
    
    /**
     * Set cursor position.
     */
    void setPosition(int row, int col);
    
    /**
     * Make LCD text visible or invisible.
     */
    void setVisible(bool visible);
    
    /**
     * Start scrolling to the left.
     */
    void scrollLeft();
    
    /**
     * Start scrolling to the right.
     */
    void scrollRight();
    
    
};


#endif
