
#include "SerialLCD.h"


SerialLCD::SerialLCD(PinName tx, PinName rx) : 
    Serial(tx, rx)
{
    baud(LCD_BAUD);
}


void SerialLCD::clear()
{
    putc(0xFE);
    putc(0x01);
}

void SerialLCD::setBacklight(int brightness)
{
    putc(0x7C);
    putc(128+brightness);
}

void SerialLCD::setPosition(int row, int col)
{
    int position = row == 0 ? (128 + col) : (192 + col);
    putc(0xFE);
    putc(position);
}

void SerialLCD::setVisible(bool visible)
{
    putc(0xFE);
    putc(visible ? 0x0C : 0x08);
}

void SerialLCD::scrollLeft()
{
    putc(0xFE);
    putc(0x18);
}

void SerialLCD::scrollRight()
{
    putc(0xFE);
    putc(0x1C);
}
    