
#include "FileSystemInterface.h"
#include "mbed.h"
#include "stringUtils.h"

#define __DEBUG
#include "dbg/dbg.h"

FileSystemInterface::FileSystemInterface()
{
    m_workDirString = getPathAsString(m_workDir);
}

string FileSystemInterface::getPathAsString(vector<string>& path)
{
    string s_path = "/";
    
    for(vector<string>::iterator it = path.begin(); it != path.end(); it++)
    {
        string& directory = *it;
        s_path += directory;
        s_path += "/";
    }
    
    return s_path;
}


string FileSystemInterface::getWorkingDirectory()
{
    return m_workDirString;
}

bool FileSystemInterface::changeWorkingDirectory(const string& dir)
{
    bool successful = false;
    
    DBG("%d\r\n", dir.find_first_of("/"));
    
    if(dir.compare("/") == 0)
    {
        //Root path
        m_workDir.clear();
        successful = true;
    }
    else if(dir.find_first_of("/") == 0)
    {
        //Absolute path
        if(isDir(dir))
        {
            m_workDir.clear();
            m_workDir = tokenize(dir, "/");
            successful = true;
        }
    }
    else if(dir.compare("..") == 0)
    {
        //Parent directory
        if(!m_workDir.empty())
        {
            m_workDir.pop_back();
            successful = true;
        }
    }
    else
    {
        //Relative Path
        string path = m_workDirString + dir;
        if(isDir(path))
        {
            m_workDir.push_back(dir);
            successful = true;
        }
    }
    
    if(successful)
    {
        m_workDirString = getPathAsString(m_workDir);
    }
    
    return successful;
}


list<File>& FileSystemInterface::getFileList()
{
    DIR* directory;
    struct dirent* entry;
    FileType type;
    m_ls.clear();
    
    directory = opendir(m_workDirString.c_str());
    if (directory != NULL) 
    {
        while ((entry = readdir(directory)) != NULL) 
        {
            string name = entry->d_name;
            string path = m_workDirString + name;
            
            if(isFile(path))
            {
                type = TYPE_FILE;
            }
            else
            {
                type = TYPE_DIR;
            }
            
            m_ls.push_back(File(name, type));
        }
    } 
    else 
    {
        //printf("Could not open directory!\n");
    }
    
    closedir(directory);
    return m_ls;
}


bool FileSystemInterface::isFile(const string& path)
{
    FILE *fp = fopen(path.c_str(), "r");
    DBG("%s : %d\r\n", path.c_str(), fp);
    bool isFile = (fp != NULL);
    if(fp)
    {
        fclose(fp);
    }
    return isFile;
}

bool FileSystemInterface::isDir(const string& path)
{
    DIR *dir = opendir(path.c_str());
    bool isDir = (dir != NULL);
    if(dir)
    {
        closedir(dir);
    }
    return isDir;
}
