/*
Copyright (c) 2011 Robert Ellis (holistic [at] robellis [dot] org [dot] uk)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef FILE_H
#define FILE_H

#include <string>
using namespace std;

/**
 * Enumeration of file types.
 */
enum FileType { TYPE_FILE, TYPE_DIR };

/**
 * File class to hold information about a file.
 */
class File
{
public:

    /**
     * Constructor.
     */
    File(string& name, FileType type);
    
    /**
     * Get file name.
     */
    string& getName() { return m_name; }
    
    /**
     * Get type. One of TYPE_FILE or TYPE_DIR.
     */
    FileType getType() { return m_type; }
    
private:

    string m_name;
    FileType m_type;

};



#endif
