/*
Copyright (c) 2011 Robert Ellis (holistic [at] robellis [dot] org [dot] uk)
 
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
 
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
 
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef FILE_SYSTEM_INTERFACE_H
#define FILE_SYSTEM_INTERFACE_H

#include "File.h"

#include <string>
#include <vector>
#include <list>
using namespace std;

/**
 * A terminal style view onto the filesystem, with the concept of current working directory.
 */
class FileSystemInterface
{
public:

    /**
     * Constructor.
     */
    FileSystemInterface();
    
    /**
     * Get the current working directory.
     */
    string getWorkingDirectory();
    
    /**
     * Change the working directory.
     * @param dir The directory to change to. Can be relative to the current working directory or absolute (begins with '/'). '..' moves to the parent directory.
     */
    bool changeWorkingDirectory(const string& dir);
    
    /**
     * Get a list of files and directories in the current working directory.
     */
    list<File>& getFileList();
    
    
private:

    string getPathAsString(vector<string>& path);
    bool isFile(const string& path);
    bool isDir(const string& path);


    vector<string> m_workDir; //current working path
    string m_workDirString;
    list<File> m_ls;

};



#endif
