#ifndef AD420_h
#define AD420_h

#include "mbed.h"

#define CLOCKINTERVAL 0.5 //us

#define MIN_VALUE 1
#define MAX_VALUE 65535

/**
 * Class for sending data to multiple AD420 DACs.
 */
class AD420
{
    
public:

    /**
     * Contructor.
     * @param _clockPin Pin connected to clock of AD420.
     * @param _latchPin Pin connected to latch of AD420.
     * @param _dataPin Pin connected to the data input of AD420.
     * @param _size Number of AD420 ICs connected to data bus.
     */
    AD420(PinName _latchPin, PinName _clockPin, PinName _dataPin, int _size);
    
    /**
     * Set a value of a single output. The actual output is not sent until a call to sendData is made.
     * @param index The index of the AD420 IC which the output is being set for.
     * @param value The value to set.
     */
    void setValue(int index, uint16_t value);
    
    /**
     * Sends all data to the AD420 ICs.
     */
    void sendData();

private:
    
    DigitalOut latchPin;
    DigitalOut clockPin;
    DigitalOut dataPin;
    int size;
    
    uint16_t* data;

};

#endif