
#include "AD420.h"

AD420::AD420(PinName _latchPin, PinName _clockPin, PinName _dataPin, int _size) :
    latchPin(_latchPin),
    clockPin(_clockPin),
    dataPin(_dataPin),
    size(_size)
{
    data = new uint16_t[_size];
    
    clockPin = 0;
    latchPin = 0;
    dataPin = 0;
}
    
void AD420::setValue(int index, uint16_t value)
{
    data[index] = value;
}

void AD420::sendData()
{
    //start sequence
    latchPin = 0;
    clockPin = 0;

    for(int i = 0; i < size; i++)
    {
        uint16_t value = data[i];
        
        for(int j=15; j>=0; j--)
        {
            dataPin = ((value&(1<<j)))>>j;
            wait_us(CLOCKINTERVAL);
            clockPin = 1;
            wait_us(CLOCKINTERVAL);
            clockPin = 0;
        }
    }
    
    //set latch
    dataPin = 0;
    clockPin = 0;
    latchPin = 1;
    wait_us(CLOCKINTERVAL);
    latchPin = 0;
}