#include "mbed.h"
#include "C12832.h"

Serial xbee1(p9, p10);
DigitalOut rst1(p30);
int dataRecieved[10];           //array to store the data that's recieved. Max amount is 10.

Serial pc(USBTX, USBRX); // tx, rx



void lezen()                    //read the data 
{
    int flag = 0;
    int adress = 0;
    int size = 0;
    int checkSum = 0;
    int checkCompare = 0;       //checksum must be equal to checkCompare
    wait_ms(100);
    flag = xbee1.getc();        //get flag. If flag is correct the transmission can continue. If not, this methode ends and will be called again in the main method. 
    if(flag == 0x7E) {
        adress = xbee1.getc();  //get the adress. 
        checkCompare =(checkCompare+ adress);   //build checkCompare
        size = xbee1.getc();    //size of the data that is to be recieved. This will help filling the array dataRecieved. 
        for(int n=0 ; n<size ; n++) {
            dataRecieved[n] = xbee1.getc();
            checkCompare +=dataRecieved[n];
        }
        checkCompare = checkCompare % 256;
        checkSum = xbee1.getc();    
        
     if(checkSum==checkCompare) {//if everything is correct it will print on to the pc. 
        pc.printf("%x,%x,%x,%x \n\r",adress,size,dataRecieved[0],checkSum);
    }

    } else {    //if the flag is incorrect, the method ends.

    }


}







int main()
{

    xbee1.baud(57600);

    rst1 = 0;   //Set reset pin to 0

    wait_ms(1);
    rst1 = 1;   //Set reset pin to 1
    wait_ms(1);




    xbee1.attach(lezen);    //interrupt triggerd 


    while (1) {


    }
}
