#include "I2C_QT1070.h"

namespace QT1070touchemulator
{

I2cQT1070::I2cQT1070(PinName sda, PinName scl, int address, int frequentie):I2CSlave(sda, scl)
{
    this->address(address);
    int registerAdress = 0;
    frequency(frequentie);
}

void I2cQT1070::check_for_instruction(void)
{
    //Checks if the I2Cslave has been adresses with something. If so, we need to
    //determine what is was for. The switch will do this for us. 
    int adressed = receive();
    switch (adressed) {
        //In this case, we already know what to send to the master.
        case I2CSlave::ReadAddressed:
            printf("Read addressed \r\n");
            send_data_to_master();
            break;
        //In this case, the master is telling the slave what he will want to read
        case I2CSlave::WriteAddressed:
            printf("Write addressed \r\n");
            save_register_adress();
            break;
    }

}

//In case the master wants to read some date, we must first know what it wants to
//read. save_register_adress() will determine what the master wants to read and 
//store it in registerAdress.  
void I2cQT1070::save_register_adress()
{
    registerAdress = read();
    printf("This is what the read function gives \r\n");
    printf("" + registerAdress);
    stop();
}

//Now we know what the master wants to read, we can send it. Depending on the 
//value of registerAdress (a.k.a. what the master wants to read) we need to send
//data to the master.
void I2cQT1070::send_data_to_master()
{
    switch(registerAdress) {
        case CHIP_ID: {
            printf("received CHIP_ID command \r\n");
            char value[1];
            value[0] = Qt1070Chip.getChipID(); 
            write(value, 1);
            break;
        }
        case FIRMWARE: {
            printf("received FIRMWARE command \r\n");
            char value2[1];
            value2[0] = Qt1070Chip.getFirmware(); 
            write(value2, 1);
            break;
        }
        case KEY_STATUS: {
            printf("received KEY_STATUS command \r\n");
            char value3[1];
            value3[0] = Qt1070Chip.getKeystate(); 
            write(value3, 1);
            break;
        }
        case RESET: {
            printf("recieved WRITE_DATA command \r\n");
            break;
        }
        default: {
            printf("unknown command\n\r");
        }
    }
}
};