#include "mbed.h"
#include "QT1070.h"
DigitalIn btnUp(p15); //28
DigitalIn btnRight(p16); //30
DigitalIn btnDown(p12); // 31
DigitalIn btnLeft(p13); // 22
DigitalIn btnCenter(p14); //14
extern "C" void mbed_reset();

namespace QT1070touchemulator
{
    //constructor
    QT1070::QT1070()
    {
        id_firmware = 0x00;
        id_chip = 0x01;
    }
    
    char QT1070::getFirmware()
    {
        return id_firmware;
    }
    
    char QT1070::getChipID()
    {
        return id_chip;
    }
    
    int QT1070::getKeystate()
    {
        char createdData = 0x00;
        if (btnDown==1) {
            createdData  = createdData | 0x01;
        } else {
            createdData= createdData & ~ 0x01;
        }
        
        if (btnUp) {
            createdData = createdData | 0x02;
        } else {
            createdData= createdData & ~ 0x02;
        }
        
        if (btnRight) {
            createdData = createdData | 0x04;
        } else {
            createdData= createdData & ~ 0x04;
        }
        
        if (btnLeft) {
            createdData = createdData | 0x08;
        } else {
            createdData= createdData & ~ 0x08;
        }
        
        if (btnCenter) {
            createdData  = createdData | 0x10;
        } else {
            createdData= createdData & ~ 0x10;
        }
    
        return createdData;
    
    }
    
    void QT1070::resetMbed()
    {
        mbed_reset();
    }

};
