/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "stats_report.h"
#include "EthernetInterface.h"

DigitalOut led1(LED1);

#define SLEEP_TIME                  500 // (msec)
#define PRINT_AFTER_N_LOOPS         20

void runNetwork();

int main()
{
    runNetwork();
    SystemReport sys_state( SLEEP_TIME * PRINT_AFTER_N_LOOPS /* Loop delay time in ms */);
    
    int count = 0;
    while (true) {
        // Blink LED and wait 0.5 seconds
        led1 = !led1;
        wait_ms(SLEEP_TIME);

        if ((0 == count) || (PRINT_AFTER_N_LOOPS == count)) {
            // Following the main thread wait, report on the current system status
            //sys_state.report_state();
            count = 0;
        }
        ++count;
    }
}

void runNetwork()
{
    EthernetInterface eth;
    TCPSocket sock1;
    
    printf("Running the network\r\n");
    
    
    eth.connect();
    
    const char *ip = eth.get_ip_address();
    const char *netmask = eth.get_netmask();
    const char *gateway = eth.get_gateway();
    printf("IP address: %s\r\n", ip ? ip : "None");
    printf("Netmask: %s\r\n", netmask ? netmask : "None");
    printf("Gateway: %s\r\n", gateway ? gateway : "None");
    
    printf("Opening socket\r\n");
    sock1.open(&eth);
    printf("binding to port\r\n");
    sock1.set_timeout(1500);
    sock1.set_blocking(false);
    sock1.bind(4000);
    printf("setting non blocking\r\n");
    
    printf("listening\r\n");
    sock1.listen();
    printf("done listening\r\n");
    
    bool connecting = true;
    int result = -1;
    TCPSocket* newSock = NULL;
    while(connecting)
    {
      wait_ms(1000);
      newSock = sock1.accept(&result);  
      printf("The error code: %d\r\n", result);
      if(newSock)
      {
        char recvedData[20];
        nsapi_size_t size = 20;
        newSock->set_blocking(true);
        nsapi_size_t nrOfRcvdBytes = 0;
        
        
        nrOfRcvdBytes = newSock->recv((void *)recvedData, size);
        if(nrOfRcvdBytes != 0)
        {
            printf("this is the data that is received\r\n");
            for(int i = 0; i < nrOfRcvdBytes; i++)
                printf("%c", recvedData[i]);
            printf("\r\n end of the data\r\n");    
                
        }
        printf("made a new sock\r\n");
        connecting = false;
      }
    } 
    
    printf("succes!");
}

void runUDPNetwork()
{
    
}
