#include "main.h"

Serial xbee1(p9, p10);
Serial pc(USBTX, USBRX);
DigitalOut rst1(p30);
int adress = 0x55;                              //Adress of this controller
int createdDataArray[1];                        //Array that stores the data created by the getData() method


DigitalIn right(p16);                           //Joystick pins on application board
DigitalIn up(p15);
DigitalIn down(p12);
DigitalIn left(p13);

DigitalIn btn1(p14);                            //extra buttons connected with internal pull up
DigitalIn btn2(p11);
DigitalIn btn3(p8);
DigitalIn btn4(p7);

void getData()                  //This method reads the data from to user controlls and stores it in a single byte. If a button is pressed it sets the corresponding bit to 1.
//It is stored in createdDataArray[0];

{
    int createdData = 0x00;
    if (down) {
        createdData  = createdData | 0x01;
    } else {
        createdData= createdData & 0xfe;
    }
    if (up) {
        createdData = createdData |= 0x02;
    } else {
        createdData= createdData & 0xfd;
    }

    if (right) {
        createdData = createdData |= 0x04;
    } else {
        createdData= createdData & 0xfb;
    }
    if (left) {
        createdData = createdData |= 0x08;
    } else {
        createdData= createdData & 0xf7;
    }

    if (! btn1) {
        createdData  = createdData | 0x10;
    } else {
        createdData= createdData & 0xef;
    }
    if (! btn2) {
        createdData = createdData |= 0x20;
    } else {
        createdData= createdData & 0xdf;
    }

    if (! btn3) {
        createdData = createdData |= 0x40;
    } else {
        createdData= createdData & 0xbf;
    }
    if (! btn4) {
        createdData = createdData |= 0x80;
    } else {
        createdData= createdData & 0x7f;
    }
    createdDataArray[0] = createdData;

}

void sendData(int adress, int dataToSend[])     //Sends the data. make sure that the size of the array giving is adjusted properly.
{

    int size = 1;                               //Size of the dataToSend array is 1
    int checkSum = 0;
    for(int n=0 ; n<size ; n++) {               //build a checksum witht the data from the array dataToSend
        checkSum += dataToSend[n];
    }
    checkSum += adress;
    checkSum  = checkSum % 256;


    xbee1.putc(0x7E);                           //send flag to signal start of data transfer

    xbee1.putc(adress);                         //adress of the functionality that will be adressed. (buttons, lcd or speaker)

    xbee1.putc(size);                           //Size of the following data (is the length of the array)

    for(int n=0 ; n<size ; n++) {               //send a byte for every databyte stored in the array. Size determines the amount of bytes send here
        xbee1.putc(dataToSend[n]);

    }
    xbee1.putc(checkSum);                       //send the checksum

    pc.printf("%x,%x,%x,%x \n\r",adress,dataToSend[0],size,checkSum);    //show data on the terminal


}




int main()
{
    btn1.mode(PullUp);                          //configure internal pull up mode
    btn2.mode(PullUp);
    btn3.mode(PullUp);
    btn4.mode(PullUp);

    wait_ms(3000);
    rst1 = 0;   //Set reset pin to 0
    wait_ms(1);
    rst1 = 1;   //Set reset pin to 1
    wait_ms(1);
    xbee1.baud(57600);



    while (1) {

        getData();                              //store data in the array CreatedDataArray
        sendData(adress, createdDataArray);     //send the data

        wait_ms(100);

    }
}
