/* Copyright (c) <2012> <P. Patel>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
  
#include "mbed.h"
#include "ToggleFlash.h"
  
void ToggleFlash::toggle() {
    _pin = !_pin;                    // Toggle pin
}
ToggleFlash::ToggleFlash(PinName pin) : _pin(pin) {
    _pin = 0;                        // Drive pin low on startup
}
ToggleFlash::ToggleFlash(PinName pin, float time) : _pin(pin) {
    _pin = 0;                        // Drive pin low on startup
    _time = time;                    // Set given time
}
void ToggleFlash::setTime(float time) {
    if (_time == time) return;       // Do nothing if time already correct
    _time = time;                    // Set new time
    if (_flasherState != 0) {        // Refresh the Flash if it was currently flashing
        _flasher.detach();
        _flasher.attach(this, &ToggleFlash::toggle, _time);
    }
}
float ToggleFlash::getTime() {
    return _time;                    // Return current time setting
 }
void ToggleFlash::enable() {
    if (_flasherState != 0) return;  // Do nothing if its already flashing
    _flasher.attach(this, &ToggleFlash::toggle, _time);  // Else attach current time setting
    _flasherState = 1;               // Update state tracker
} 
void ToggleFlash::disableTo(int state) {
    _flasher.detach();               // Stop flashing
    _flasherState = 0;               // Update state tracker
    _pin = state;                    // Drive pin to state
}
int ToggleFlash::readFlasher() {
    return _flasherState;            // Return state of the Flash
}
int ToggleFlash::read() {
    return _pin;                     // Return state of the pin
}