#ifndef _STEERING_H
#define _STEERING_H

#include "mbed.h"
#include "Digital_InOut.h"
#include "KS0108.h"

#include "Arial12.h"
#include "Arial14.h"
#include "Comic24.h"
#include "vivaldi16.h"

#define SWITCH_ID 410

#define BATTERY_VOLTAGE_ID 0x304
#define BATTERY_POWER_ID 0x306
#define BATTERY_CURRENT_ID 0x305

#define PCM_STATE_ID 20

#define BATTERY_MIN_CELLVOLTAGE_ID 0x301
#define BATTERY_MAX_CELLVOLTAGE_ID 0x300
#define BATTERY_AVG_CELLVOLTAGE_ID 0x302

#define BATTERY_MIN_CELLTEMPERATURE_ID 0x30A
#define BATTERY_MAX_CELLTEMPERATURE_ID 0x309
#define BATTERY_AVG_CELLTEMPERATURE_ID 0x30B
#define AMS_BATTERY_STATE 0x30E          // AIRS 7 and 6 // Precharge 3

Serial pc(USBTX,USBRX);
CAN CAN_Steering(p9,p10);
Digital_InOut CAN_Silent(p3_26, 0, output);

KS0108 display(p26, p21, p22, p23, p25, p24, p8, p7, p6, p5, p13, p14, p12, p11); 
Ticker call_ledstream;

Digital_InOut l1(p1_28,1,output);//    SW2
Digital_InOut l2(p1_26,1,output);//    SW4
    
Digital_InOut l3(p1_24,1,output);//    SW6
Digital_InOut l4(p0_24,1,output);//    SW8

Digital_InOut u1(p1_14,0,output);//    SW9 
Digital_InOut u2(p1_9,0,output);//     SW11

Digital_InOut u3(p1_4,0,output);//     SW13
Digital_InOut u4(p1_0,0,output);//     SW15

AnalogOut ledstream(p18);

//SW1 - SW3
Digital_InOut boSW1(p1_29,1,output);
Digital_InOut biSWBR(p1_27,pull_down,input);     //BRight

Digital_InOut boSW5(p1_25,1,output);
Digital_InOut biSWBL(p1_22,pull_down,input);     //BLeft

//Digital_InOut boSW5(P1_25,1,output);
//Digital_InOut biSW7(P1_22,pull_down,input);

Digital_InOut boSW10(p1_10,1,output);
Digital_InOut biSWTR(p1_8,pull_down,input);     //TRight

Digital_InOut boSW14(p1_1,1,output);
Digital_InOut biSWTL(p0_25,pull_down,input);    //TLeft

typedef union convert{
        float FLOAT;
        char C_FLOAT[4];
        }ftc;

char SwitchName[15][13]={
    "fuse",
    "ams",
    "imd",
    "pcm",
    "brkp",
    "lft",
    "intl",
    "brko",
    "ckpt",
    "rgt",
    "hvd",
    "tsms"
};

int SwitchPosition[13][2]={
    {0,16},     //fuse
    {25,16},    //ams
    {50,16},    //imd
    {70,16},    //pcm
    {93,16},    //brkp
    {117,16},   //lft
    {0,32},     //intl
    {17,32},    //brko
    {42,32},    //ckpt
    {65,32},    //rgt
    {81,32},    //hvd
    {102,32},   //tsm
    };
    
int maxScreen=5;
int screen; 
char drive[4];
CANMessage Txmsg_Drive(0x601,drive,sizeof(drive));
#endif /* STEERING_H */    