/*
Test Code
#include "Digital_Out.h"

//Serial pc(USBTX,USBRX);

int main()
{
    Digital_Out ledPin1(p1_18,1);
    Digital_Out ledPin2(p1_20,0);
    Digital_Out ledPin3(p1_21,1);
    Digital_Out ledPin4(p1_23,0);
     
    
    wait(0.5);
    while(1)
    {
        ledPin1= !ledPin1;
        ledPin2= !ledPin2;
        ledPin3= !ledPin3;
        ledPin4= !ledPin4;
         
        wait(0.5);
        ledPin1= !ledPin1;
        ledPin2= !ledPin2;
        ledPin3= !ledPin3;
        ledPin4= !ledPin4;
        
        wait(0.5);
    }

Digital_Out pin(p0_0);

DigitalOut myled(LED1);

Timer t;
int main() {
   t.reset();
   t.start();
   for (int i = 0; i < 1000000; i++){
    pin = 1;
    pin = 0;
   }
       t.stop();

   unsigned int time1 = t.read_us(); 
    
    t.reset();
    t.start();
    for (int i = 0; i < 1000000; i++) {
    myled = 1;
    myled = 0;
    }
    t.stop();
    unsigned int time2 = t.read_us();
    printf("Library time: %d, mbed time: %d\r\n", time1, time2);
    while(1) {

    }
}
*/

#ifndef DIGITAL_OUT_H
    #define DIGITAL_OUT_H
    
    #include"mbed.h"
        
    #define _PINSEL_BASE 0x4002C000
    #define _FIODIR_BASE 0x2009C000
    #define _FIOSET_BASE 0x2009C018
    #define _FIOCLR_BASE 0x2009C01C
    #define _FIOPIN_BASE 0x2009C014
    
    #ifndef _PIN_
        #define _PIN_
        typedef struct
        {
            int port;
            int pin;
        }Pin;
    #endif /* _PIN_ */
    
    #ifndef _PIN_NAME_
        #define _PIN_NAME_
        // Note many pins are not available as fully functional GPIOs, they are ommitted below
        enum Pin_Name
        {
            p0_0 = 0,
            p0_1 = 1,
            p0_2 = 2,
            p0_3 = 3,
            p0_4 = 4,
            p0_5 = 5,
            p0_6 = 6,
            p0_7 = 7,
            p0_8 = 8,
            p0_9 = 9,
            p0_10 = 10,
            p0_11 = 11,
            /*p0_12 = 12,
            p0_13 = 13,
            p0_14 = 14,*/
            p0_15 = 15,
            p0_16 = 16,
        
            p0_17 = 17,
            p0_18 = 18,
            p0_19 = 19,
            p0_20 = 20,
            p0_21 = 21,
            p0_22 = 22,
            p0_23 = 23,
            p0_24 = 24,
            p0_25 = 25,
            p0_26 = 26,
          /*  p0_27 = 27,
            p0_28 = 28,
            p0_29 = 29,
            p0_30 = 30,*/
        
        
            p1_0 = 100,
            p1_1 = 101,
           /* p1_2 = 102,
            p1_3 = 103,*/
            p1_4 = 104,
           /* p1_5 = 105,
            p1_6 = 106,
            p1_7 = 107,*/
            p1_8 = 108,
            p1_9 = 109,
            p1_10 = 110,
           /* p1_11 = 111,
            p1_12 = 112,
            p1_13 = 113,*/
            p1_14 = 114,
            p1_15 = 115,
        
            p1_16 = 116,
            p1_17 = 117,
            p1_18 = 118,
            p1_19 = 119,
            p1_20 = 120,
            p1_21 = 121,
            p1_22 = 122,
            p1_23 = 123,
            p1_24 = 124,
            p1_25 = 125,
            p1_26 = 126,
            p1_27 = 127,
            p1_28 = 128,
            p1_29 = 129,
            p1_30 = 130,
        
        
            p2_0 = 200,
            p2_1 = 201,
            p2_2 = 202,
            p2_3 = 203,
            p2_4 = 204,
            p2_5 = 205,
            p2_6 = 206,
            p2_7 = 207,
            p2_8 = 208,
            p2_9 = 209,
            p2_10 = 210,
            p2_11 = 211,
            p2_12 = 212,
            p2_13 = 213,
           /* p2_14 = 214,
            p2_15 = 215,
        
            p2_16 = 216,
            p2_17 = 217,
            p2_18 = 218,
            p2_19 = 219,
            p2_20 = 220,
            p2_21 = 221,
            p2_22 = 222,
            p2_23 = 223,
            p2_24 = 224,
            p2_25 = 225,
            p2_26 = 226,
            p2_27 = 227,
            p2_28 = 228,
            p2_29 = 229,
            p2_30 = 230,*/
        
        
           /* p3_0 = 300,
            p3_1 = 301,
            p3_2 = 302,
            p3_3 = 303,
            p3_4 = 304,
            p3_5 = 305,
            p3_6 = 306,
            p3_7 = 307,
            p3_8 = 308,
            p3_9 = 309,
            p3_10 = 310,
            p3_11 = 311,
            p3_12 = 312,
            p3_13 = 313,
            p3_14 = 314,
            p3_15 = 315,
        
            p3_16 = 316,
            p3_17 = 317,
            p3_18 = 318,
            p3_19 = 319,
            p3_20 = 320,
            p3_21 = 321,
            p3_22 = 322,
            p3_23 = 323,
            p3_24 = 324,*/
            p3_25 = 325,
            p3_26 = 326,
            /*p3_27 = 327,
            p3_28 = 328,
            p3_29 = 329,
            p3_30 = 330,*/
        
            /*p4_0 = 400,
            p4_1 = 401,
            p4_2 = 402,
            p4_3 = 403,
            p4_4 = 404,
            p4_5 = 405,
            p4_6 = 406,
            p4_7 = 407,
            p4_8 = 408,
            p4_9 = 409,
            p4_10 = 410,
            p4_11 = 411,
            p4_12 = 412,
            p4_13 = 413,
            p4_14 = 414,
            p4_15 = 415,
        
            p4_16 = 416,
            p4_17 = 417,
            p4_18 = 418,
            p4_19 = 419,
            p4_20 = 420,
            p4_21 = 421,
            p4_22 = 422,
            p4_23 = 423,
            p4_24 = 424,
            p4_25 = 425,
            p4_26 = 426,
            p4_27 = 427,*/
            p4_28 = 428,
            p4_29 = 429,
            /*p4_30 = 430*/
        
        };
    #endif /* _PIN_NAME_ */
    
    
    class Digital_Out
    {
        private:    Pin _pin;
        public:     Digital_Out(Pin_Name IPin)
                    {
                        _pin.port=(IPin/100);
                        _pin.pin=(IPin%100);
                        const int PINSELx = ((_pin.port*2) + (1* (_pin.pin > 15) ? 1:0));
                        const int FIODIRx = _pin.port;
                        
                        *(uint32_t*)(_PINSEL_BASE + (PINSELx*4)) &= ~(1 << ((_pin.pin%16)*2) | (1 << (((_pin.pin%16)*2)+1)));          //GPIO
                        *(uint32_t*)(_FIODIR_BASE + (FIODIRx*0x20)) |= (1 << _pin.pin);                                        //Output
                    }
                    
                    Digital_Out(Pin_Name IPin, int value)
                    {
                        _pin.port=(IPin/100);
                        _pin.pin=(IPin%100);
                        const int PINSELx = ((_pin.port*2) + (1* (_pin.pin > 15) ? 1:0));
                        const int FIODIRx = _pin.port;
                        
                        *(uint32_t*)(_PINSEL_BASE + (PINSELx*4)) &= ~(1 << ((_pin.pin%16)*2) | (1 << (((_pin.pin%16)*2)+1)));           //GPIO
                        *(uint32_t*)(_FIODIR_BASE + (FIODIRx*0x20)) |= (1 << _pin.pin);                                        //Output
                        *(uint32_t*)((_FIOSET_BASE*value) + (_FIOCLR_BASE*(1-value)) + (_pin.port*0x20)) |= (1 << _pin.pin);   //Write     
                    }
                    
                    void write(int value)
                    {
                        if (value != 1 && value != 0) return;
                        *(uint32_t*)((_FIOSET_BASE*value)+(_FIOCLR_BASE*(1-value)) + (_pin.port*0x20)) |= (1 << _pin.pin);     //Write     
                    }
                    
                    int read()
                    {
                        return ((*(uint32_t*)(_FIOPIN_BASE +_pin.port*0x20) & (1 << _pin.pin)) >> _pin.pin);                          //Read
                    }
                    
                    Digital_Out& operator= (int value)
                    {
                        write(value);
                        return *this;
                    }
                    
                    Digital_Out& operator= (Digital_Out& rhs)
                    {
                        write(rhs.read());
                        return *this;
                    }
                    
                    operator int()
                    {
                        return read();
                    }
    };

#endif /*DIGITAL_OUT_H*/