/* Copyright (c) <2012> <P. Patel>, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
// ------------------------------ MAX518 Interfacing Library ------------------------------------

 
#include "MAX518.h"
#include "mbed.h"

// Class constructor 1, create i2c connection, update instance variables
DAC::DAC(PinName sda, PinName scl, int address, int freq, bool ack) : _i2c(sda, scl) {
    _address = address;
    _ack = ack;
    _i2c.frequency(freq);
}
// Class constructor 2, create i2c connection, update instance variables
DAC::DAC(PinName sda, PinName scl, int address, bool ack) : _i2c(sda, scl) {
    _address = address;
    _ack = ack;
}
// Class constructor 3, create i2c connection, update instance variables
DAC::DAC(PinName sda, PinName scl, int address, int freq) : _i2c(sda, scl) {
    _address = address;
    _ack = true;
    _i2c.frequency(freq);
}
// Class constructor 4, create i2c connection, update instance variables
DAC::DAC(PinName sda, PinName scl, int address) : _i2c(sda, scl) {
    _address = address;
    _ack = true;
}
// Set output of both DAC channels with ints 0 - 255
bool DAC::setDAC(int a, int b) {
    if (a > 255 || a < 0 || b > 255 || b < 0)
        return false;                             // Return if int a or int b is out of range
    int check = 0;                                // Counter for ACK signals

    _i2c.start();
    check += _i2c.write(_address);                // Write address
    check += _i2c.write(0);                       // Select Channel 1
    check += _i2c.write(a);                       // Write output value
    check += _i2c.write(1);                       // Select Channel 2
    check += _i2c.write(b);                       // Write output value
    _i2c.stop();                                  // End communication (trigger DAC to update outputs)
    
    if (_ack && check != 5) return false;         // Return false if device did not acknowledge when expected
    else return true;
}

// Set output of DAC Channel 1 with int 0 - 255
bool DAC::setCh1(int n) {
    if (n > 255 || n < 0) return false;           // Return if n is out of range
    int check = 0;                                // Counter for ACK signals

    _i2c.start();
    check += _i2c.write(_address);                // Write address
    check += _i2c.write(0);                       // Select Channel 1
    check += _i2c.write(n);                       // Write output value
    _i2c.stop();                                  // End communication (trigger DAC to update outputs)
    
    if (_ack && check != 3) return false;         // Return false if device did not acknowledge when expected
    else return true;
}

// Set output of DAC Channel 2 with int 0 - 255
bool DAC::setCh2(int n) {
    if (n > 255 || n < 0) return false;           // Return if n is out of range
    int check = 0;                                // Counter for ACK signals

    _i2c.start();
    check += _i2c.write(_address);                // Write address
    check += _i2c.write(1);                       // Select Channel 1
    check += _i2c.write(n);                       // Write output value
    _i2c.stop();                                  // End communication (trigger DAC to update outputs)
    
    if (_ack && check != 3) return false;         // Return false if device did not acknowledge when expected
    else return true;
}

// Reset DAC (all outputs to 0)
bool DAC::reset() {
    int check = 0;                                // Counter for ACK signals

    _i2c.start();
    check += _i2c.write(_address);                // Write address
    check += _i2c.write(16);                      // Reset command (all outputs to 0)
    _i2c.stop();                                  // End communication (trigger DAC to update)
    
    if (_ack && check != 2) return false;         // Return false if device did not acknowledge when expected
    else return true;
}

// Power down DAC into silent monitoring mode (outputs also go to 0)
bool DAC::powerDown() {
    int check = 0;                               // Counter for ACK signals

    _i2c.start();
    check += _i2c.write(_address);                // Write address
    check += _i2c.write(8);                       // Power down DAC into silent mode (outputs also go to 0)
    _i2c.stop();                                  // End communication (trigger DAC to update)
    
    if (_ack && check != 2) return false;         // Return false if device did not acknowledge when expected
    else return true;
}