#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button 
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn buttonblue(PTD0);
InterruptIn buttonred(PTD5);//need to change the address
DigitalOut ledblue(LED_BLUE);
DigitalOut ledred(LED_RED);

volatile int pressREvent = 0 ;
volatile int pressBEvent = 0 ;
//volatile bool switchledblue = true; //switch blue led
//volatile bool switchledred = true; //switch red led

// This function is invoked when then interrupt occurs
void buttonblueCallback()
{   
   pressBEvent = 1;
}

void buttonredCallback()
{
    pressREvent = 1;
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() 
{
    
    bool allow_flash_red = true;
    bool allow_flash_blue = true;
    
    buttonblue.mode(PullUp);  
    buttonred.mode(PullUp);            // Ensure button i/p has pull up
   
    buttonblue.fall(&buttonblueCallback) ;   // Attach function to falling edge
    buttonred.fall(&buttonredCallback) ; 
    while (true)
    {
 
        if (pressREvent == 1)
        {   
            allow_flash_red = !allow_flash_red;
            pressREvent =0;
        }   
        
        if (pressBEvent == 1)
        {
                        
            allow_flash_blue = !allow_flash_blue;
            pressBEvent = 0;
        }
        
        if(allow_flash_red)
        {
            ledred = !ledred;
        }
        
        if(allow_flash_blue)
        {
            ledblue = !ledblue;
        
        }
        
        Thread::wait(500);
    }
       
}