#include "mbed.h"
#include "rtos.h"
#include "wdt.h"

// Sample program using the Watchdog
// ---------------------------------
//    * Three threads co-operate to flash two LEDs
//    * A simple way to inject a fault, by pressing a button 
//    * The watchdog is configured with a 32ms timeout

#define ON 1
#define OFF 0
DigitalOut led_red(LED_RED, ON);
DigitalIn button(PTD0, PullUp);
DigitalOut led1(PTC12, OFF);
DigitalOut led2(PTC13, OFF);
Serial pc(USBTX, USBRX); 

// This ticker is used to feed the watch dog
Ticker tick;

// Threads
Thread threadT(osPriorityNormal,1000); // timer thread 
Thread threadLED1(osPriorityNormal,1000); // thread LED1
//Thread threadLED2(osPriorityNormal,1000); // thread LED2
Thread threaddetection(osPriorityNormal,1000);

//define the state of watch dog
enum wState {Working, Stopped} ;
wState watchdogflag;
AnalogIn ainled1(A0); //LED1 ADC INPUT
//AnalogIn ainled2(A1); //LED2 ADC INPUT
float volt1,volt2;


// ------------Fault Injection Button-------------
//  Wait while the button is down
//     Use this to simulate a STUCK fault
// -----------------------------------------------
void waitButton() {
   
    while (!button){
        pc.printf("stop watchdog");
        watchdogflag=Stopped;
        }
}

// ---Thread for controlling LED 1----------------
//   Turn LED1 on/off in response to signals 
// -----------------------------------------------
void led1_thread() {  // method to run in thread
    osEvent evt ;
    while (true) {
        evt = Thread::signal_wait(0x0); // wait for any signal
        if (evt.status == osEventSignal) {
            if (evt.value.signals & 0x01) 
            {
                led1 = ON ;
                
            }
            if (evt.value.signals & 0x02) led1 = OFF ;
        } 
    }
}

// ---Thread for controlling LED 2----------------
//   Turn LED2 on/off in response to signals 
// -----------------------------------------------
void led2_thread() {  // method to run in thread
    osEvent evt ;
    while (true) {
        evt = Thread::signal_wait(0x0); // wait for any signal
        if (evt.status == osEventSignal) {
            if (evt.value.signals & 0x01) 
            {
               led2 = ON ;       
            }
            if (evt.value.signals & 0x02) led2 = OFF ;
        } 
        // waitButton() ; // POSSIBLE FAULT HERE
    }
}

// ---Thread for timing --------------------------
//   Send signals to the other threads
// -----------------------------------------------
void timer_thread() {  // method to run in thread
    while (true) {
        Thread::wait(250) ;
        threadLED1.signal_set(0x1) ;//on
 //       threadLED2.signal_set(0x1) ;//on
        Thread::wait(250) ;
        threadLED1.signal_set(0x2) ;//off
 //       threadLED2.signal_set(0x2) ;//off
        // waitButton() ; // POSSIBLE FAULT HERE
    }
}

void detection_thread() 
{ 
    int counter=0;
    while (1) 
    {
        volt1 = ainled1;
     //          pc.printf("%f\n\r",volt1);
        if (volt1>0.90) 
        {
            pc.printf("short circuit\n\r");
            led_red=0;
        }
        else
        {
           if(led1==1)
           {
                if ((volt1<0.1))        
                {    
                    counter++;
                    if (counter>5)
                    {
                         pc.printf("open circuit\n\r");
                        if(led_red==1)led_red=0;
                        counter =0;
                    }
                }
                else
                {
                    pc.printf("%f\n\r",volt1);
                    if (led_red==0)led_red=1;
                } 
            }
        }
 
       waitButton(); // POSSIBLE FAULT HERE     
    }     
}

// -----------MAIN-------------------------------
//    Configure watchdog. Start threads. 
//    Show start up with RED for 1sec
//    Remember the watchdog is running
//       - 1024ms to set it once
//       - then must feed it every 32ms  
// ----------------------------------------------

void watchdog()
{
    
    if (watchdogflag==Working)
        {
           wdt_kick_all(); 
        } 
}


int main(void) {
    
    wdt_32ms() ; // initialise watchdog - 32ms timeout
    watchdogflag = Working;
    tick.attach_us(callback(&watchdog), 20000); 
    
    // start threads
    threadT.start(&timer_thread) ; // start the timer thread 
    threadLED1.start(&led1_thread) ; // start the LED1 control thread 
    threaddetection.start(&detection_thread);
    
    // show start-up
    led_red = OFF;
    Thread::wait(1000) ;//1ms
    led_red = ON;
   
}