#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    DigitalOut led1(LED1);
    DigitalOut led2(LED2);
    DigitalOut led3(LED3);
//    PwmOut rled(LED1);
 //   PwmOut gled(LED2);
//    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx
    
    
    float x, y, z;
    float x1,y1,z1;
    float errorrange = 0.1;
    int filter = 3;
    int countflag = 0;
    int  oritation=0 ;
   


    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
    
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
       
        Thread::wait(300);
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        
        
        switch (oritation)
        {
            case 0:
            {
                led1= 1;
                led2=1;
                led3 =1;
                break;
            }
            case 1:
            {
                led1= 0;
                led2=1;
                led3 =1;
                break;
            }
            case 2:
            {
                led1= 1;
                led2=0;
                led3 =1;
                break;
        
            }
            case 3:
            {
                led1= 1;
                led2=1;
                led3 =0;
                break;
            }
            case 4:
            {
                led1= 1;
                led2=0;
                led3 =0;
                break;
            }
            case 5:
            {
                led1= 0;
                led2=0;
                led3 =1;
                break;
            }
            case 6:
            {
                led1= 0;
                led2=1;
                led3 =0;
                break;
            }
               
        }   
        float temp = (x+y+z);
  
        if(((temp<1.2)&&(temp>0.8))||((temp<-0.8)&&(temp>-1.2)))
        {
            if ((abs(z-1.00)<=errorrange))
            {
                if (countflag == 0)
                {
                    pc.printf("flat");
                    countflag = filter;
                    oritation = 1;
                  
                }
                else
                {
                    countflag--;
                }
            } 
         
            if (abs(1.00+x)<=errorrange)
            {
                if (countflag == 0)
                {
                    pc.printf("right"); 
                    countflag = filter; 
                    oritation = 2;
               }
               else
                {
                   countflag--;
               }
            }  
      
            if (abs(x-1.00)<=errorrange)
            {
                if (countflag == 0)
                {
                    pc.printf("left");
                    countflag = filter;
                    oritation = 3;  
                }
                else
                {
                    countflag--;
                }
            }   
            
            
            if (abs(y-1.00)<=errorrange)
            {
                if (countflag == 0)
                {
                    pc.printf("up");
                    countflag = filter;
                    oritation = 4; 
                }
                else
                {
                    countflag--;
                }
            }   
        
         if (abs(y+1.00)<=errorrange)
            {
                if (countflag == 0)
                {
                    pc.printf("down");
                    countflag = filter;
                     oritation = 5;
                }
                else
                {
                    countflag--;
                }
            }   
         if (abs(z+1.00)<=errorrange)
            {
                if (countflag == 0)
                {
                    pc.printf("turn");
                    countflag = filter;
                    oritation = 6;  
                }
                else
                {
                    countflag--;
                }
            }
 
        }
        else
            {
                oritation = 0;
            }
            
       
               
    } 
        
 }

