#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    DigitalOut ledr(LED1);
    DigitalOut ledg(LED2);
    DigitalOut ledb(LED3);
//    PwmOut rled(LED1);
 //   PwmOut gled(LED2);
//    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx
    Timer time;
    
    
    float x, y, z;
    float errorrange = 0.1;
    int filter = 3;
    int countflag = 0;
    int step =1;
    int state = 1;
    int timeflag = 0;
    float t,t3;
    ledr = 1;
    ledg = 1;
    ledb = 1;
   


    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
    
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
       
        Thread::wait(300);
     //   pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        
        switch (state)
        {
            case 1:
            {
                if ((timeflag ==0)&&(step ==1))
                {
                    time.start();
                    ledg =0;
                    timeflag =1;
                    pc.printf("flat start\n\r");
                }
                else
                {
                    t = time.read();
                    pc.printf("time:%1.3f\n\r",t);
                    if(t>10.00)
                    {
                        time.stop();
                        time.reset();
                        step=2;
                        timeflag=0;
                        pc.printf("flat stop\n\r");    
                    }
                    
                }
                break;
            }
            
            case 2:
            {
                if ((timeflag == 0)&&(step==2))
                {
                    time.start();
                    timeflag=1;           
                    pc.printf("right start\n\r");         
                }
                else
                {
                    t= time.read();
                    pc.printf("time:%1.3f\n\r",t);
                    if((t>2.0)&&(t<6.0))
                    {
                        step=3;
                        timeflag=0;
                        pc.printf("right end\n\r");
                    }
        
                }
                break;
            }
            
            case 3:
            {
                if ((step==3)&&(timeflag==0))
                {
                    t3 = time.read();
                    timeflag = 1;
                    pc.printf("up start\n\r");         
                }
                else
                {
                    t = time.read();
                    pc.printf("time:%1.3f\n\r",t);
                    if(((t-t3)>4.0)&&((t-t3)<8))
                    {
                        step =1;
                        timeflag = 0;
                        state = 0;
                        pc.printf("up end\n\r");
                        time.stop();
                        time.reset();         
                    }
                }
                break;
            }
            case 4:
            {
                pc.printf("error\n\r"); 
                ledg = 1;
                ledr = 0;
                step =1;
                timeflag = 0;
                state = 0;
                time.reset(); 
                break;
                    
            }
        }
        
          
        
        float temp = (x+y+z);
        if(((temp<1.2)&&(temp>0.8))||((temp<-0.8)&&(temp>-1.2)))
        {
            if ((abs(z-1.00)<=errorrange))
            {
               
                if (countflag == 0)
                {
                    pc.printf("flat");
                    countflag = filter;
                    state = 1;
                    
                }
                else
                {
                    countflag--;
                }
            } 
         
            if (abs(1.00+x)<=errorrange)
            {
                
                  if (countflag == 0)
                {
                    pc.printf("right"); 
                    countflag = filter; 
                    state = 2;
               }
               else
                {
                   countflag--;
               }
            }
                    
                    
            if (abs(y-1.00)<=errorrange)
            {
                      
                if (countflag == 0)
                {
                    pc.printf("up");
                    countflag = filter;
                    state = 3; 
                }
                else
                {
                    countflag--;
                }
            }   
           if (abs(y+1.00)<=errorrange)
            {
                if (countflag == 0)
                {
                    pc.printf("down");
                    countflag = filter;
                    state = 4;
                }
                else
                {
                    countflag--;
                }
            }   
            
            if (abs(z+1.00)<=errorrange)
            {
                if (countflag == 0)
                {
                    pc.printf("turn");
                    countflag = filter;
                    state = 4;  
                }
                else
                {
                    countflag--;
                }
            }
         
        }
    }
}

