
// LAB 3 SAMPLE PROGRAM 1
//   Revised for mbed 5

#include "mbed.h"



Ticker tick;                // Ticker for reading analog
AnalogIn ain(A0) ;          // Analog input
DigitalOut led1(LED_RED);
 
DigitalOut lede1(PTD4) ;          // Extend LED
DigitalOut lede2(PTD5) ;  
DigitalOut lede3(PTD2) ;  
DigitalOut lede4(PTD3) ;
DigitalOut lede5(PTD1) ;  


InterruptIn button(PTD0); //add button
volatile int pressEvent = 0 ;

void buttonCallback()
{   
   pressEvent = 1;
}

Serial pc(USBTX, USBRX); // tx, rx, for debugging

// Message type
typedef struct {
  uint16_t analog; /* Analog input value */
} message_t;

// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Low pass filter  
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 
void readA0() {
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }       
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}

// Main program
//   Initialise variables
//   Attach ISR for ticker
//   Procss messages from mailbox    
int main() {
    button.mode(PullUp);  
    button.fall(&buttonCallback); 
    
    led1 = 1 ; // turn off 
 //   led2 = 0;
    int volts = 0.0 ;
  //  const int vToString = 100 ;
   // const int threshold = 55;
 //   const std::array <int,6>threshold{55,110,165,220,275,330};
    int threshold[6] = {55,110,165,220,275,330};
    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;


    tick.attach_us(callback(&readA0), 10000); // ticks every 10ms
    
 //   tick1.attach_us(callback(&readA0), 10000); // ticks every 10ms
    while (true) {
        if (pressEvent == 1)
        {   
            for(int i =0;i<6;i++)
            {
                threshold[i] = (volts/6)*(i+1);
              
                pressEvent = 0;
            }
        }   
             
        osEvent evt = mailbox.get(); // wait for mail 
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            volts = (mess->analog * 330) / 0xffff ;
            mailbox.free(mess) ;  // free the message space
     
           if (volts<=(threshold[0]))
            {
                led1 = 1 ;
                lede1 = 0;
                lede2 = 0;
                lede3 = 0;
                lede4 = 0;
                lede5 = 0;
            }
           
           if ((volts<=threshold[1])&&(volts>threshold[0]))
            {
                led1 = 1 ;
                lede1 = 1;
                lede2 = 0;
                lede3 = 0;
                lede4 = 0;
                lede5 = 0;
            }
            if ((volts<=threshold[2])&&(volts>threshold[1]))
                {
                led1 = 1 ;
                lede1 = 1;
                lede2 = 1;
                lede3 = 0;
                lede4 = 0;
                lede5 = 0;
            }
             if ((volts<=threshold[3])&&(volts>threshold[2]))
                {
                led1 = 1 ;
                lede1 = 1;
                lede2 = 1;
                lede3 = 1;
                lede4 = 0;
                lede5 = 0;
            }
              if ((volts<=threshold[4])&&(volts>threshold[3]))
            {
                led1 = 0 ;
                lede1 = 1;
                lede2 = 1;
                lede3 = 1;
                lede4 = 1;
                lede5 = 0;
            }
                if ((volts<=threshold[5])&&(volts>threshold[4]))
            {
                led1 = 0 ;
                lede1 = 1;
                lede2 = 1;
                lede3 = 1;
                lede4 = 1;
                lede5 = 1;
            }
            vToString(volts, vstring) ;
//            vToString(threshold[5], vstring1) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                {
                    pc.printf(vstring);
 //               
                  
                }
            counter = 0 ;
            }
        }

    }
}
