//AUTOR: Pedro Santos
//                          plainas_14@hotmail.com
//DATA: 19/13/2015
//NOTAS: http:
//CODIGO PARA: programa de teste para entradas e saidas da placa kl25Z

#include "mbed.h"

Serial pc(USBTX, USBRX);                  // Declare the serial port

//********************************************************************
//********************************************************************
//DEFINIÇÃO DE ENTRADAS E SAIDAS USADAS NO PROGRAMA
//SAIDAS DIGITAIS
DigitalOut  led1     (PTD0);
DigitalOut  led2     (PTD3);
DigitalOut  led3     (PTD2);
DigitalOut  led4     (PTE5);

DigitalOut led_r(LED1);               // Define digital outputs for each LED color
DigitalOut led_g(LED2);
DigitalOut led_b(LED3);

//ENTRADAS DIGITAIS
DigitalIn tecla1 (PTE20);
DigitalIn tecla2 (PTE21);
DigitalIn tecla3 (PTE22);
DigitalIn tecla4 (PTE23);

int count_1000ms=0;
int count_500ms=0;
int count_100ms=0;

char f_100ms=0;
char f_500ms=0;
char f_1000ms=0;

//********************************************************************
//********************************************************************
void TPM0_IRQHandler(void){ //10ms interrupt

    count_1000ms++;
    count_500ms++;
    count_100ms++;
            
     if(count_100ms==10){
     //   led_b=!led_b;
        led3=!led3;        
        count_100ms=0;
    }    
    
     if(count_500ms==50){
      //  led_g=!led_g;
       led2=!led2;        
        count_500ms=0;
    }
    
    if(count_1000ms==100){
       // led_r=!led_r;
        led1=!led1;
        count_1000ms=0;
    }
    
  
    TPM0->SC= 0x000000cF; //Volta a defenir a cena
    return;               
}

//********************************************************************
//********************************************************************
void init_timer0(){

   // TPM0->SC=0x2b; 
//   TPM0_DMA=0;//->DMA=0; //disable dma
//   TPM0_SC->TOF=0; //flag de interruption
//   TPM0_SC->TOIE=1; //enable interupt flag
//   TPM0_SC->CPWMS=0; //enable interupt flag
//   TPM0_SC->CMOD=1; //cmod register
//   TPM0_SC->ps=8; //pre- escalar div pag 553 datasheet


 //   TMP0->CNT=100;
 //   TMP0->MOD=5000;
 
 led_b=0;
    
    wait(1);
    
    led_b=!led_b;
    
    SIM->SOPT2=(SIM->SOPT2 | (1UL<<24));
    SIM->SCGC6=(SIM->SCGC6 | (1UL<<24));//enable TPM 0,1
    //TPM0->SC=0x0;
 //
    //TPM0->CNT=200;
    //TPM0->MOD|=4850;
    //TPM0->SC|=0xEF;//0008
    

    TPM0->SC=0x0;
 
    TPM0->CNT=0x0;
    TPM0->SC=0x00000040; //disable LPTPM
    TPM0->MOD=3750; //max value = 1/(48mhz/128) -> 10^-3/ans =3750
    TPM0->SC=0x000000cF;//enable LPTPM
    

    
}


//********************************************************************
//****************************** MAIN ********************************
//********************************************************************
int main()
{
    led_r=1;
    led_g=1;
    led_b=1;
    init_timer0();
    
    pc.baud (38400);  

    NVIC_SetVector(TPM0_IRQn, (uint32_t)&TPM0_IRQHandler);
    NVIC_SetPriority(TPM0_IRQn, 1);
    NVIC_EnableIRQ(TPM0_IRQn); 

//****************************** LOOP ********************************
    while(1) {

        led_b = 0;
        wait(0.1); //Wait 100ms
        led_b = 1;
        wait(0.1); //Wait 100ms
        
  /*      
    // pc.printf("%u \n\r",TPM0->CNT);      // Send a status message

        //testa tecla 1 e 2
        if(tecla1==1 || tecla2==1)
            led3=1;
        else
            led3=0;

        //testa tecla 3 e 4
        if(tecla3==1 || tecla4==1)
            led4=1;
        else
            led4=0;
  */          

    }
}