#include "mbed.h"

#define LEDS 0xFF

PortOut ledport(PortC, LEDS);
//DigitalOut RLY1(PC_10);
DigitalOut Buzzer(PB_0);
DigitalIn  Button(PC_13);
Serial pc(PA_9,PA_10); // tx rx
DigitalOut myled(LED1);

DigitalOut M1A(PB_4);
DigitalOut M1B(PB_10);

DigitalOut M2A(PB_5);
DigitalOut M2B(PC_4);

PwmOut mypwm(PWM_OUT);

Ticker toggle_led_ticker;

int i = 0;
bool RcvCmd = 0;
bool Stop = 1;
bool Start = 0;
int  Tick = 0;
int  Duty = 33;
int  Times = 0;
char RcvChar = 0;

//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
//-------------------------------------------------------------//
void Slower (void)
{
    ++Times;
    
    if(Times >=5)
    {
        Times = 0;
        Buzzer = 1;
        wait(0.2);
        Buzzer = 0; 
        
        
        if(Duty > 20)
        {
            --Duty;
           mypwm.pulsewidth_us(Duty);
        }
        else
        {

        }
    }
    
}    
//-------------------------------------------------------------//
void Faster (void)
{
    ++Times;
    
    if(Times >=5)
    {
        Times = 0;
        Buzzer = 1;
        wait(0.2);
        Buzzer = 0; 
        
        if(Duty < 45)
        {
           ++Duty;
           mypwm.pulsewidth_us(Duty); 
        }    
        else
        {
            
        }    
    }
    
    
    
}   
//-------------------------------------------------------------//
void Beep (void)
{
 Buzzer = 1;
 wait(0.2);
 Buzzer = 0;   
}
//-------------------------------------------------------------//
void toggle_led() 
{
    myled = !myled;
    
    ++Tick;
    
    if(Tick >= 10)
    {
        Stop = 1;
    }
    else
    {
       
    }    
    
    
}
//-------------------------------------------------------------//
void Detener (void)
{
    M1A = 0;
    M1B = 0;
    M2A = 0;
    M2B = 0;
    //Buzzer = 0;
}
//-------------------------------------------------------------//
void Derecha (void)
{
    
    M1A = 0;
    M1B = 1;
    M2A = 1;
    M2B = 0;
    
    Stop = 0;
    Tick = 0;
    //Buzzer = 1;
}
//-------------------------------------------------------------//
void Izquierda (void)
{
    M1A = 1;
    M1B = 0;
    M2A = 0;
    M2B = 1;
    
    Stop = 0;
    Tick = 0;
    //Buzzer = 1;
}
//-------------------------------------------------------------//
void Atras (void)
{
    M1A = 1;
    M1B = 0;
    M2A = 1;
    M2B = 0;
    
    Stop = 0;
    Tick = 0;
    //Buzzer = 1;
}
//-------------------------------------------------------------//
void Adelante(void)
{
    M1A = 0;
    M1B = 1;
    M2A = 0;
    M2B = 1;
    
    Stop = 0;
    Tick = 0;
    //Buzzer = 1;
    
}
//-------------------------------------------------------------//



int main() 
{
 
 mypwm.period_us(50);
 mypwm.pulsewidth_us(Duty);
 
 toggle_led_ticker.attach(&toggle_led, 0.01);
 
 
 while(1) 
 {
  if(pc.readable())
  {
   RcvChar = pc.getc();
   
   
   
   switch(RcvChar)
   {
     case 'F':
     {
      Adelante();
      
      Tick = 0;
     }
     break;
     
     case 'B':
     {
      Atras();
      
     }
     break;
     
     case 'I':
     {
      Izquierda();

     }
     break;
     
     case 'D':
     {
      Derecha();
 
     }
     break;
     
     
     case 'P':
     {
      Beep();
     }
     break;
     
     case 'X':
     {
      Faster();
     }
     break;
     
     case 'Y':
     {
      Slower();
     }
     break;
     
     default:
     {
         Detener();
     }
     break;
      
     
   } //end switch
  }
  
  
   if(Stop)
   {
       Detener();
   } 
 }   // end main loop
}
