#ifndef MOTOR_H
#define MOTOR_H

#include "mbed.h"


class Moteur {
public:

    /** Create a motor control interface    
     *
     * @param pwm A PwmOut pin, driving the H-bridge enable line to control the speed
     * @param fwd A DigitalOut, set high when the motor should go forward
     * @param rev A DigitalOut, set high when the motor should go backwards
     */
    Moteur(PinName pwm, PinName avancer, PinName reculer);
    void vitesse(float vit); /*@param speed The speed of the motor as a normalised value between -1.0 and 1.0*/

protected:
    PwmOut _pwm;
    DigitalOut _avancer;
    DigitalOut _reculer;
};

#endif
