#include "mbed.h"
#include "iostream"
#include "Moteur.h"
#include "Encodeur.h"
#include "Robot.h"
#include "VL53L0X.h"
#include "SpwfInterface.h"
#include "TCPSocket.h"

using namespace std;

Moteur moteurGauche(D3, D12, D4); // pwm, avancer, reculer
Moteur moteurDroit(D11, D13, D5); 

Encodeur encodeurGauche(A2);
Encodeur encodeurDroit(A4);

PwmOut servoMoteur(PC_9);
Serial pc(USBTX, USBRX);

Serial bluetooth(A0, A1); 
 
DigitalOut shutdown1_pin(PC_6); /*range1_XSHUT*/
DevI2C devI2c(D14, D15); 
VL53L0X laser(&devI2c, &shutdown1_pin, NC);

SpwfSAInterface spwf(D8, D2, false);

TCPSocket socket(&spwf);

void envoie(char buffer[100]);

int main() {
    
    int* tabPortee;
    tabPortee = new int[3];

    tabPortee[0] = 0;
    tabPortee[1] = 0;
    tabPortee[2] = 0;

    Robot robot(moteurGauche, moteurDroit, &encodeurGauche, &encodeurDroit, servoMoteur, laser, tabPortee);
    
    int err;    
    //char * ssid = "Zte-Mobile";
    //char * seckey = "Meximieux01800";  
    char * ssid = "Python";
    char * seckey = "pythonserveur";  
       
    pc.printf("\r\n\n\nPHASE D'INITIALISATION DU ROBOT\n");
    pc.printf("\rConnection a AP...\n");
            
    if(spwf.connect(ssid, seckey, NSAPI_SECURITY_WPA2)) {      
        pc.printf("\rConnecte\n\n");
    } else {
        pc.printf("\rErreur de Connection\n\n");
        return -1;
    }   

    const char *ip = spwf.get_ip_address();
    const char *mac = spwf.get_mac_address();
    
    pc.printf("\rIP Addresse : %s\n", (ip) ? ip : "Pas d' IP");
    pc.printf("\rMAC Addresse: %s\n", (mac) ? mac : "Pas de MAC");    
    
    SocketAddress addr(&spwf, "st.com");   
    pc.printf("\rst.com: %s\n", addr.get_ip_address());    

    pc.printf("\rConnecte au serveur\n");
    
    //err = socket.connect("192.168.43.68", 8080);
    err = socket.connect("192.168.1.101", 8080);
    //err = socket.connect("192.168.1.150", 8080);
    if(err!=0) {
      pc.printf("\rImpossible de se connecter au socket, erreur = %d!!\r\n", err); 
      return -1;
    } else pc.printf("\rConnecte au serveur hote\r\n\n"); 
    
    int boucle(1);
    int fin(0);
    char commande;
    double distanced;
    double distanceg;
    int distg;
    int distd;
    int count = 0;
    
    pc.baud(9600);
    bluetooth.baud(9600);
    laser.init_sensor(0x56);
    
    robot.encodeurs_zero();
    
    while(fin == 0) {
    
       cout << "\rEN ATTENTE D'UNE COMMANDE..." << endl;
       while (boucle) { 
            if(bluetooth.readable()) {
                commande = bluetooth.getc();
                boucle = 0;
            }
        }
                
        boucle = 1;
        char buffer[100];
        
        switch(commande) { 
            case '1': 
                robot.roues_rouler(GO);
                cout << "\rGO" << endl;
                robot.encodeurs_afficher();
                break;
                
            case '2': 
                robot.roues_rouler(BACK); 
                cout << "\rBACK" << endl;
                robot.encodeurs_afficher();
                break;
                
            case '3': 
                robot.roues_rouler(GO_GAUCHE); 
                cout << "\rGO_GAUCHE" << endl;
                robot.encodeurs_afficher();
                break;
                
            case '4': 
                robot.roues_rouler(GO_DROITE); 
                cout << "\rGO_DROITE" << endl;
                robot.encodeurs_afficher();
                break;
                
            case '5': 
                robot.roues_rouler(GAUCHE); 
                cout << "\rGAUCHE" << endl;
                robot.encodeurs_afficher();
                break;
                
            case '6': 
                robot.roues_rouler(DROITE); 
                cout << "\rDROITE" << endl;
                robot.encodeurs_afficher();
                break;
                
            case '7': 
                robot.roues_rouler(FULLBACK); 
                cout << "\rFULLBACK" << endl;
                robot.encodeurs_afficher();
                break;
                
            case '8': 
                cout << "\rBALAYER" << endl;
                robot.roues_rouler(BALAYER);
                
                distanced = robot.distanceDroit();
                distanceg = robot.distanceGauche();
                distd = static_cast<int>(distanced);
                distg = static_cast<int>(distanceg);
                        
                sprintf(buffer, "%d", distg);
                cout << "\r\nEnvoie de la distance parcourue par la roue gauche" << endl;
                envoie(buffer);
                        
                sprintf(buffer, "%d", distd);
                cout << "\rEnvoie de la distance parcourue par la roue droite" << endl;
                envoie(buffer);
                
                robot.encodeurs_zero();
                
                cout << "\rDISTANCE 1 =" << robot.getTabPortee(0) << endl;
                cout << "\rDISTANCE 2 = " << robot.getTabPortee(1) << endl;
                cout << "\rDISTANCE 3 = " << robot.getTabPortee(2) << endl;
                
                sprintf(buffer, "%d", robot.getTabPortee(0));
                cout << "\r\nEnvoie de la distance 1" << endl;
                envoie(buffer);
                
                sprintf(buffer, "%d", robot.getTabPortee(1));
                cout << "\rEnvoie de la distance 2" << endl;
                envoie(buffer);
                
                sprintf(buffer, "%d", robot.getTabPortee(2));
                cout << "\rEnvoie de la distance 3" << endl;
                envoie(buffer);
                 break;
                 
            case '9': 
                fin = 1; 
                
                pc.printf("\rFermeture du Socket\n");
                socket.close();
                pc.printf ("\rSocket ferme\n");
                sprintf(buffer, "%d", 0);
                pc.printf("\rDonnee envoyee\n"); 
                count = socket.send(buffer, sizeof buffer);
                spwf.disconnect();
                printf ("\rWIFI deconnecte...\n\n\n");
                
                break;
        }
        robot.roues_stop();
    }
}

void envoie(char buffer[100]) {
        int count = 0;
        count = socket.send(buffer, sizeof buffer);
                
        if(count > 0) {
        pc.printf("\rDonnee envoyee: ");
        buffer [count]='\0';
        printf("%s\n\n", buffer);  
        }
        
        else pc.printf("\rImpossible d'envoyer la donnee\n\n");
}

 
