#include "Encodeur.h"
#include <iostream>

using namespace std;

Encodeur::Encodeur(PinName enc_in): _enc_in(enc_in){ 

    _enc_in.mode(PullUp);
    
    // Invoke interrupt on both falling and rising edges
    _enc_in.fall(callback(this, &Encodeur::incrementer));
    _enc_in.rise(callback(this, &Encodeur::incrementer));
}

void Encodeur::zero(){
    _compteur = 0;
    _tour = 0.0;
}

void Encodeur::incrementer(){
    _compteur++;   
    _tour = _tour  + 0.125;
}
int Encodeur::lire_compteur(){
    return _compteur;
}

double Encodeur::lire_tour(){
    return _tour;
}

void Encodeur::afficher() const {
    cout << "compteur = " << _compteur << ", tour = " << _tour << ", distance = " << (_tour*3.14*63) << endl;
}

double Encodeur::distance() {
    return (_tour*3.14*63);
}

