#include "mbed.h"
#include "MMA8451Q.h"
#include "USBMouse.h"
#include "TSISensor.h"
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)

#define DEBUGCONSOLE 1  /* 9600bd serial to OpenSWD COM port */

USBMouse mouse;
Serial pc(USBTX,USBRX);
 
void mbutton_detect( float percent)
{
    #define LBTN_MIN    75
    #define LBTN_MAX    100
    #define RBTN_MIN    1
    #define RBTN_MAX    30
    #define DBL_MIN     35
    #define DBL_MAX     70
    
    int pos = percent * 100;
    static bool ltouchflg = false;
    static bool rtouchflg = false;

    /* left button */
    if((pos >= DBL_MIN))   
    {
        if( ltouchflg == false ) 
        {
            mouse.press(MOUSE_LEFT);
            ltouchflg = true;
#if DEBUGCONSOLE            
            pc.printf("ltouch \n");
#endif            
        }
    }
    
    /* right button */
    if((pos <= DBL_MAX) && (pos > RBTN_MIN))   
    {
        if( rtouchflg == false ) 
        {
            mouse.press(MOUSE_RIGHT);
            rtouchflg = true;
#if DEBUGCONSOLE              
            pc.printf("rtouch \n");
#endif            
        }
    }
    
    /* release left */
    if( (pos < DBL_MIN))
    {
        if( ltouchflg == true )
        {
            mouse.release(MOUSE_LEFT);
            ltouchflg = false;
#if DEBUGCONSOLE              
            pc.printf("lrelease \n");
#endif            
        }
    } 
    
    /* release right */
    if( (pos < RBTN_MIN) || (pos >= DBL_MAX) )
    {
        if( rtouchflg == true )
        {
            mouse.release(MOUSE_RIGHT);
            rtouchflg = false;
#if DEBUGCONSOLE              
            pc.printf("rrelease \n");
#endif            
        }
    }
}
 
 
int main(void) {
 
    /* acc sensor init */
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    
    /* TSI init */
    TSISensor tsi;
    
    /* LED init */
    PwmOut rled(LED_RED);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);
 
    while (true) { 
    
        /* -1*accY correspond to mouse axe X; acc X correspond to mouse Y */
        mouse.move( -1*int(acc.getAccY()*20), int(acc.getAccX()*20) );
        
        mbutton_detect( tsi.readPercentage());
      
        rled = 1.0 - abs(acc.getAccX());
        gled = 1.0 - abs(acc.getAccY());
        bled = 1.0 - abs(acc.getAccZ());
        
        wait(0.001);
    }
}

