#include "mbed.h"
#include "MMA8451Q.h"
#include "USBMIDI.h"
#include "TSISensor.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

#define C1  0,187  
#define D1  0.250 
#define E1  0.312 
#define F1  0.375      
#define G1  0.437 
#define A1  0.5        
#define B1  0.562 
#define C2  0.625  
#define D2  0.687      
#define E2  0.750   
#define F2  0.812     
#define G2  0.875  
#define A2  0.937       
#define B2  1      
#define C3  1.062       
#define D3  1.125  
#define E3  1,187       
#define F3  1.250      
#define G3  1.312       
#define A3  1.375  
#define B3  1.437       
#define C4  1.5    
#define D4  1.562       
#define E4  1.625  
#define F4  1.687 
#define G4  1.749 
#define A4  1.811 
#define B4  1.873 

//1.935



#define NC1 48
#define ND1 50
#define NE1 52
#define NF1 53
#define NG1 55
#define NA1 57
#define NB1 59
#define NC2 60
#define ND2 62
#define NE2 64
#define NF2 65
#define NG2 67
#define NA2 69
#define NB2 71
#define NC3 72
#define ND3 74
#define NE3 76
#define NF3 77
#define NG3 79
#define NA3 81
#define NB3 83
#define NC4 84
#define ND4 86
#define NE4 88
#define NF4 89
#define NG4 91
#define NA4 93
#define NB4 95

Serial pc(USBTX,USBRX);
USBMIDI midi;
TSISensor tsi;

 
void show_message(MIDIMessage msg) {
    switch (msg.type()) {
        case MIDIMessage::NoteOnType:
            printf("NoteOn key:%d, velocity: %d, channel: %d\n", msg.key(), msg.velocity(), msg.channel());
            break;
        case MIDIMessage::NoteOffType:
            printf("NoteOff key:%d, velocity: %d, channel: %d\n", msg.key(), msg.velocity(), msg.channel());
            break;
        case MIDIMessage::ControlChangeType:    
            printf("ControlChange controller: %d, data: %d\n", msg.controller(), msg.value());
            break;
        case MIDIMessage::PitchWheelType:
            printf("PitchWheel channel: %d, pitch: %d\n", msg.channel(), msg.pitch());
            break;
        default:
            printf("Another message\n");
    }    
}
 

 
int main() { 

    int note=48, n=48;
    float notechng;
    int pitch;
    int modulation;
    float m;
    
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
             
    midi.attach(show_message);         // call back for messages received 
     
    while (1) { 
#if 0      
        /* TEST CODE */
        /* test pitch - commented in in - endif*/
        midi.write(MIDIMessage::NoteOn(57));
        for(int c=0; c<127; c= c+1){  
            
            midi.write(MIDIMessage::ControlChange(1, c));
            //midi.write(MIDIMessage::PitchWheel(c));
            pc.printf("Pitch: %d \n", c);         
        }   
        midi.write(MIDIMessage::NoteOff(57));          
            wait(0.5);         
#endif
#if 1
        /* read note */
        notechng = 1 - acc.getAccX();

        /* get modulatio */
        m = ((1 + acc.getAccY()) * 63); 
        modulation = int(m); 
        
        /* get pitch */
        pitch = (int(tsi.readPercentage() * 8192) - 8192);
        
        if(notechng > C1) note= NC1;
        if(notechng > D1) note= ND1;
        if(notechng > E1) note= NE1;
        if(notechng > F1) note= NF1;
        if(notechng > G1) note= NG1;
        if(notechng > A1) note= NA1;
        if(notechng > B1) note= NB1;
        if(notechng > C2) note= NC2;
        if(notechng > D2) note= ND2;
        if(notechng > E2) note= NE2;
        if(notechng > F2) note= NF2;
        if(notechng > G2) note= NG2;
        if(notechng > A2) note= NA2;
        if(notechng > B2) note= NB2;  
        if(notechng > C3) note= NC3;
        if(notechng > D3) note= ND3;
//        if(notechng > E3) note= NE3;
        if(notechng > F3) note= NF3;
        if(notechng > G3) note= NG3;
        if(notechng > A3) note= NA3;
        if(notechng > B3) note= NB3;
        if(notechng > C4) note= NC4;
        if(notechng > D4) note= ND4;
        if(notechng > E4) note= NE4;
        if(notechng > F4) note= NF4;
        if(notechng > G4) note= NG4;
        if(notechng > A4) note= NA4;
        if(notechng > B4) note= NB4; 
        
        pc.printf("note: %d \n", note);          
        pc.printf("notechng: %f \n", notechng);

        if (note != n) {
            midi.write(MIDIMessage::NoteOff(n));
            n=note; 
            midi.write(MIDIMessage::NoteOn(n));       
        }
        
        midi.write(MIDIMessage::ControlChange(1, modulation));
        midi.write(MIDIMessage::PitchWheel(pitch));
        
        wait(0.1);
#endif      
    }
}