#ifndef MPL115A1_H
#define MPL115A1_H
// MPL115A1 register address map
#define MPL115A1_STARTPRES 0x20 // start pressure measurement
#define MPL115A1_PRESH    0x00    // 80
#define MPL115A1_PRESL    0x02    // 82
#define MPL115A1_A0MSB    0x08    // 88
#define MPL115A1_A0LSB    0x0A    // 8A
#define MPL115A1_B1MSB    0x0C    // 8C
#define MPL115A1_B1LSB    0x0E    // 8E
#define MPL115A1_B2MSB    0x10    // 90
#define MPL115A1_B2LSB    0x12    // 92
#define MPL115A1_C12MSB   0x14    // 94
#define MPL115A1_C12LSB   0x16    // 96
#define MPL115A1_C11MSB   0x18    // 98
#define MPL115A1_C11LSB   0x1A    // 9A
#define MPL115A1_C22MSB   0x1C    // 9C
#define MPL115A1_C22LSB   0x1E    // 9E
SPI spi(p5,p6,p7);
DigitalOut sdn(p8);
DigitalOut cs(p9);
    long int uiPadc;
    unsigned char uiPH, uiPL;
unsigned int readRegister(uint8_t address);
void writeRegister(uint8_t address, char data);
float calculatePressurekPa()
{
    // read pressure, temperature and coefficients, calculate and return absolute pressure [kPa]
float p;
    writeRegister(MPL115A1_STARTPRES, 0x00); // start temperature and pressure conversions
    wait_ms(2); // AN: data is typically ready after 3ms, DS for both: max. 1ms
    
    // read raw pressure
    uiPH = readRegister(MPL115A1_PRESH);
    uiPL = readRegister(MPL115A1_PRESL);
        
    uiPadc = (unsigned int) uiPH << 8;
    uiPadc += (unsigned int) uiPL & 0x00FF;
    uiPadc-=28800;
    uiPadc= -uiPadc;
    p=uiPadc/128;
    return p;
    
   
}
unsigned int readRegister(uint8_t address)
{
    // returns the contents of any 1 byte register from any address
    // sets the MSB for every address byte (READ mode)

    unsigned int byte;

    address |= 0x80;

    cs = 0;
    spi.write(address);
    byte = spi.write(0x00);
    cs = 1;

    return byte;
}
void writeRegister(uint8_t address, char data)
{
    //write any data byte to any single address
    //adds a 0 to the MSB of the address byte (WRITE mode)

    address &= 0x7F;

    cs = 0;
    wait_ms(1);
    spi.write(address);
    wait_ms(1);
    spi.write(data);
    wait_ms(1);
    cs = 1;
}
#endif