#include "mbed.h"
#include "USBHostKeyboard.h"
int price=0,items=0,temp=0;
unsigned long long int code=0;
DigitalOut led(LED1);
void update_price(int p);
void onKey(uint8_t key) {
    printf("%c", key);
    if(key!=0x0A)
    {
    temp=key;
    temp-=48;
    code=temp+code*10;
    }
    else
    {
    switch(code)
    {
        case 42204268: update_price(200);
        break;
        case 8906002080021: update_price(25);
        break;
        case 8904043901015: update_price(17);
        break;
        case 8904004403756:update_price(36);
        break;
}
code=0;
}
}
void update_price(int p)
{
                        items++;
                        price+=p;
                        printf("No. of items=%d\tPrice=Rs.%d\n",items,price);
                        }
void keyboard_task(void const *) {
    
    USBHostKeyboard keyboard;
    
    while(1) {
        // try to connect a USB keyboard
        while(!keyboard.connect())
            Thread::wait(500);
    
        // when connected, attach handler called on keyboard event
        keyboard.attach(onKey);
        
        // wait until the keyboard is disconnected
        while(keyboard.connected())
            Thread::wait(500);
    }
}

int main() {
    Thread keyboardTask(keyboard_task, NULL, osPriorityNormal, 256 * 4);
    while(1) {
        led=!led;
        Thread::wait(500);
    }
}
