#include "mbed.h"
#include "TextLCD.h"
DigitalOut myled(LED1);
DigitalOut myled_(LED2);

Semaphore minMutex;
Semaphore secMutex;

RawSerial pc(USBTX, USBRX); // tx, rx
TextLCD lcd(p15, p16, p17, p18, p19, p20);

void hundredth(void const *n);

int sec, hsec, min;
int pause, startFlag; 

void minute(void const *n)
{
    while(1)
    {
        minMutex.wait();
        min++;
    }
}

void second(void const *n)
{
    while(1)
    {
        secMutex.wait();
        sec++;
        if(sec == 60)
        {
            minMutex.release();
            sec=0;
        }
    }
}    

void hundredth(void const *n)
{
//    if(startFlag == 1)
    {
        hsec++;
        if(hsec == 100)
        {
            secMutex.release();
            hsec = 0;
        }
    }
}

void display(void const *n)
{
    while(1)
    {
        if(!pause)
        {
            lcd.locate(0,0);
            lcd.printf("%2d:%2d:%2d",min,sec,hsec);  
            Thread::wait(10);
        }
    }
}    
 

void key()
{
    char c = pc.getc();
    if(c == 's' || c == 'S')
    {
        startFlag = !startFlag;
    }
    else if(c == 'p' || c == 'P')
    {
        pause = !pause;
    }
    else if(c == 'r' || c == 'R')
    {
        min = 0;
        sec = 0;
        hsec = 0;
    }
}    

int main()
{
    hsec = 0;
    sec = 0;
    min = 0;
    pause = 0;
    startFlag = 0;
        
    RtosTimer hund(hundredth, osTimerPeriodic,(void *)0);

    Thread secondThread(second);
    Thread minuteThread(minute);
    Thread displayThread(display);
    
    secondThread.set_priority(osPriorityNormal);
    minuteThread.set_priority(osPriorityNormal);
    displayThread.set_priority(osPriorityIdle);



    hund.stop();

    pc.attach(&key, Serial::RxIrq);
    
    while(1)
    {
        if(startFlag)
        {
            hund.start(10);
        }
        else
        {
            hund.stop();
        }
        Thread::wait(10);
    }
}