#include "mbed.h"

AnalogIn analog_value(A1);
Serial blue(D8, D2);
BusOut outled(D6, D5, D4, D3);

void segment()
{
    float analog;
    float sum;
    analog = analog_value.read();
    sum = analog *3.3;
    blue.printf("%0.2f\n",sum);
    wait(0.5);
}

int main()
{

    blue.baud(9600);
    int data, num;
    int state_menu = 0;
    int state_show = 1;
    int state_next = 0;

    while(1) {

        if(blue.readable()) {
            data = blue.getc();
        }

        if(state_menu == 0 && state_show == 1) {
            blue.printf("_____HELLO_____\n");
            blue.printf("___Choose_Mode___\n");
            blue.printf("[Mode1] Show number since 0-9, input '1'\n");
            blue.printf("[Mode2] Read volt from VR, input '2'\n");
            state_show = 0;
        }

        else if(state_menu == 1 && state_show ==1) {
            blue.printf("Enter mode 1\n");
            blue.printf("If you want to exit mode, input 'x'\n");
            state_show = 0;
            state_next = 1;
        }

        else if(state_menu == 2 && state_show == 1) {
            blue.printf("Enter mode 2\n");
            blue.printf("If you want to exit mode, input 'x'\n");
            state_show = 0;
            state_next = 2;
        }

        if(state_menu == 0 && data == 49) {
            state_menu = 1;
            state_show = 1;
        }

        else if (state_menu == 0 && data == 50) {
            state_menu = 2;
            state_show = 1;
        }

        if(state_menu == 1 && state_next == 1) {

            data = blue.getc();
            num = data%48;
            outled = num;
        }
        if(state_menu == 1 && data == 120) {
            blue.printf("Exit mode[1]\n");
            state_menu = 0;
            state_show = 1;
        }

        if(state_menu == 2 && state_next ==2) {
            segment();
        }
        if (state_menu == 2 && data == 120) {
            blue.printf("Exit mode[2]\n");
            state_menu = 0;
            state_show = 1;
        }

    }
}
