#include "mbed.h"

AnalogIn analog_value(A1);
BusOut segOut1(D11, D10);
BusOut segOut2(D15, D14,D13,D12);
BusOut lab1(D9, D8, D7, D6, D5, D4, D3, D2);
DigitalIn Inled(USER_BUTTON);
Serial pc(SERIAL_TX, SERIAL_RX);

void segment()
{
    float analog;
    analog = analog_value.read();
    int volt = analog * 3300;
    int divide = volt/1000;
    int unit = (volt % 1000)/100;
    segOut1 = divide;
    segOut2 = unit;
    lab1 = 0;
//    wait(0.4);
}

void ledout()
{
    float analog;
    int volt33000,bin_value;
    analog = analog_value.read();
    volt33000 = analog*33000;

    if (volt33000 >= 33000/8*8) {
        bin_value = 256-1;
    } else if (volt33000 >= 33000/8*7) {
        bin_value = 128-1;
    } else if (volt33000 >= 33000/8*6) {
        bin_value = 64-1;
    } else if (volt33000 >= 33000/8*5) {
        bin_value = 32-1;
    } else if (volt33000 >= 33000/8*4) {
        bin_value = 16-1;
    } else if (volt33000 >= 33000/8*3) {
        bin_value = 8-1;
    } else if (volt33000 >= 33000/8*2) {
        bin_value = 4-1;
    } else if (volt33000 >= 33000/8*1) {
        bin_value = 2-1;
    } else if (volt33000 >= 33000/8*0) {
        bin_value = 1-1;
    }
    lab1 = bin_value;
    segOut1 = 0;
    segOut2 = 0;

}

int main()
{
    int state = 0;

    while(1) {
        if (Inled == 0 && state == 1) {
            state = 0; //lab1
        } else if (Inled == 0 && state == 0) {
            state = 1; //lab2
        }

        if (state == 0) {
            ledout();
        } else if (state == 1) {
            segment();
        }
    }
}
