/*Programa tomado y adaptado de Henry Leinen*/
/*Algunas modificaciones se realizan con propósitos educativos*/
#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "DebouncedIn.h"

//RtcCls rtc(p28, p27, p29, true);
Rtc_Ds1307 rtc(PTE0, PTE1);

/****************Configurar Salidas********************/
Serial pc(USBTX, USBRX, "pc");
PwmOut led1(LED1);
PwmOut led2(LED2);

DebouncedIn Stop(PTE2);
DebouncedIn CLK(PTE3);
DebouncedIn DT(PTE4);
DebouncedIn SW1(PTE5);
DebouncedIn Snooze(PTB11);
/*****************Definir variables********************/
char buffer[128];
int readptr = 0;
int started=0;
int wakeup=0;
//int snooze=0;
int howmanytimes = 0;
//Alarm variables;
int hour1;
int min1;
int sec1;

/*******************Rutinas********************/

void Encoder()
{
    int NewClk;
    int OldClk;
    int NewDt;
    int OldDt;
    int NewPos;
    int OldPos;
    int counter2=0;
    pc.printf("Setting Alarm...\n\r") ;
    pc.printf("The current alarm settings : %02d:%02d\n", hour1,min1);
    pc.printf("Hour:\n\r") ;
       
    while(howmanytimes != 0)
    {           
        NewClk = CLK.read();
        NewDt=DT.read();
        NewPos = 2*NewClk + NewDt;
        if (NewClk != OldClk || NewDt != OldDt)
        {   
            counter2++;         
            if ((OldPos == 0 && NewPos == 2) ||(OldPos == 2 && NewPos == 3) || (OldPos == 3 && NewPos == 1) || (OldPos == 1 && NewPos == 0)) //Incremento;
            {
                
                if (howmanytimes ==1 && counter2 ==2){hour1++; if(hour1>23){hour1=0;}};
                if (howmanytimes ==2 && counter2 ==2){min1++; if(min1>59){min1=0;}};
                
                printf("%d : %d\n", hour1, min1);
            }
            else if ((OldPos == 0 && NewPos == 1) ||(OldPos == 1 && NewPos == 3) || (OldPos == 3 && NewPos == 2) || (OldPos == 2 && NewPos == 0))
            {
                if (howmanytimes ==1 && counter2 ==2 ){hour1--; if(hour1<0){hour1=23;}};
                if (howmanytimes ==2 && counter2 ==2){min1--; if(min1<0){min1=59;}};
                printf("%d : %d\n", hour1, min1);
            }         
             
            if (counter2==2){counter2=0;}
        }
        OldClk=NewClk;
        OldDt=NewDt;
        OldPos = NewPos;
        
        if(SW1.falling())
        {
            howmanytimes++;
            if(howmanytimes==2){pc.printf("Minutes...\n");}
            if(howmanytimes > 2) {howmanytimes=0;}
        }
    }
}


//Main
int main() {
    int c;
    int counter1=0;
    
    led1.period(2.0);
    led1.write(1.0);
    led2.period(2.0);
    led2.write(1.0);
    
    Rtc_Ds1307::Time_rtc tm = {}; //Se da un nombre a la estructura usada para almacenar la información del reloj
    
    
    /*Inicializar el reloj*/
    pc.printf("************************\n Be Welcome! \n ************************\n");    
                if (rtc.getTime(tm) )                     {
                        pc.printf("The current time is : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
                        pc.printf("The current date is :  %02d/%02d/%04d\n",  tm.mon, tm.date, tm.year);
                        
                    }
    
   while(started==0)
  
   {  pc.printf("Is it right? yes or not?\n");
        while( (c = pc.getc()) != '\n') 
            {
                buffer[readptr++] = c;
            }
                    
        buffer[readptr++] = 0; //Almaceno un cero en la posición después del cambio de línea;
        
        if (strncmp(buffer, "yes", 3) == 0) //Date and time are ok, lets start!
        {
            pc.printf("Lets start...\n");
            rtc.startClock();            
            started=1; 
        }
        
        else if (strncmp(buffer, "not", 3) == 0)
        {
                            //  perform write
                pc.printf("Enter the date (date 0..31)");
                pc.scanf("%d", &tm.date);
                pc.printf("Enter the date (month 1..12)");
                pc.scanf("%d", &tm.mon);
                pc.printf("Enter the date (year)");
                pc.scanf("%d", &tm.year);
                pc.printf("Enter the time (hours 0..23)");
                pc.scanf("%d", &tm.hour);
                pc.printf("Enter the time (minutes 0..59)");
                pc.scanf("%d", &tm.min);
                pc.printf("Enter the time (seconds 0..59)");
                pc.scanf("%d", &tm.sec);
                pc.printf("Performing write operation\n");
            
                while(pc.readable()) 
                    pc.getc();
                rtc.setTime(tm, false, false);
                rtc.startClock(); 
                started=1;         
        }
        
        else 
        {
            pc.printf("Try again \n");
            readptr=0;
        }
    pc.printf("\n");
    }//while start
   
   //Esto es temporal
   if (tm.min==59){   hour1 = tm.hour+1;   min1=0;}
   else {hour1 = tm.hour;   min1=tm.min+1;}
   
    
    /*Ciclo infinito para correr el programa*/
    while(1)    
    {
        wait(0.01);
       counter1++; //Aumento el contador 
 
 /*******Get the time*********/
        if (counter1==90) //Cuento 900ms para mostrar algo en pantalla;
            {
                    counter1=0;        
                    if (rtc.getTime(tm) )
                    {
                            pc.printf("The current time is : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
                            pc.printf("The current date is : %02d/%02d/%04d\n",  tm.mon, tm.date, tm.year);
                        if (hour1==tm.hour && min1==tm.min && sec1 == tm.sec)
                        {
                            wakeup=1;
                            pc.printf("Wakeup bitch!..\n");
                            led1.write(0.5);
                            led2.write(1.0);
                        }        
                        }  //if rtc
                    }    //if counter  
    
    
    if (SW1.falling() && wakeup != 1)
    {
        led2.write(0.5);   
        howmanytimes++;
        Encoder();
        led2.write(1.0);  
    }
    
    if (Stop.rising()&& wakeup==1)
    {
        pc.printf("Alarm Stopped ... \n");
        led1.write(1.0);
        wakeup=0;
    }
        if (Snooze.rising() && wakeup==1)//In case of pushing snooze;
    {
        pc.printf("Two more minutes please!!!!\n");
        led1.write(1.0);
        wakeup=0;
       
        if (tm.min==58){min1=0;hour1=hour1+1;}
        else if (tm.min==59){min1=1;hour1=hour1+1;}
        else { min1=tm.min+1;} //two more minutes please}
        pc.printf("Alarm will sound again at: %02d:%02d:%02d\n", hour1, min1,sec1);
        
    }
    }//while
   
}//main




